/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.map.pp.AbstractIntegerCharacterMap;
import net.morilib.util.primitive.map.pp.IntegerCharacterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerCharacterHashMap
extends AbstractIntegerCharacterMap
implements Serializable {
    private static final long serialVersionUID = -2524637876889987554L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object MARK_A = new Object();
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<IntegerCharacterMap.PrimitiveEntry> entrySet;

    /*
     * Unable to fully structure code
     */
    public IntegerCharacterHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl13
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl13:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public IntegerCharacterHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntegerCharacterHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public IntegerCharacterHashMap() {
        this(16, 0.75f);
    }

    public IntegerCharacterHashMap(IntegerCharacterMap mp) {
        this(16, 0.75f);
        this.putAllElement(mp);
    }

    private Iterator<IntegerCharacterMap.PrimitiveEntry> entrySetIterator() {
        return new Iterator<IntegerCharacterMap.PrimitiveEntry>(){
            private int ptr = -1;
            private Ent e = this._next();
            private Ent remove = null;
            private int exModCount;
            {
                this.exModCount = IntegerCharacterHashMap.this.modCount;
            }

            /*
             * Unable to fully structure code
             */
            private Ent _next() {
                v0 = this.e = this.ptr < 0 ? null : Ent.access$0(this.e);
                if (this.e == null) ** GOTO lbl6
                return this.e;
lbl-1000:
                // 1 sources

                {
                    if (IntegerCharacterHashMap.access$2(IntegerCharacterHashMap.this)[this.ptr] == null) continue;
                    return IntegerCharacterHashMap.access$2(IntegerCharacterHashMap.this)[this.ptr];
lbl6:
                    // 2 sources

                    ** while (++this.ptr < IntegerCharacterHashMap.access$2((IntegerCharacterHashMap)IntegerCharacterHashMap.this).length)
                }
lbl7:
                // 1 sources

                return null;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public IntegerCharacterMap.PrimitiveEntry next() {
                this.remove = this.e;
                if (this.e == null) {
                    throw new NoSuchElementException();
                }
                if (this.exModCount != IntegerCharacterHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.e = this._next();
                return this.remove;
            }

            @Override
            public void remove() {
                if (this.remove == null) {
                    throw new IllegalStateException();
                }
                IntegerCharacterHashMap.this._remove(this.remove.key);
                this.exModCount = IntegerCharacterHashMap.this.modCount;
                this.remove = null;
            }
        };
    }

    @Override
    public Set<IntegerCharacterMap.PrimitiveEntry> primitiveEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<IntegerCharacterMap.PrimitiveEntry>(){

                @Override
                public Iterator<IntegerCharacterMap.PrimitiveEntry> iterator() {
                    return IntegerCharacterHashMap.this.entrySetIterator();
                }

                @Override
                public int size() {
                    return IntegerCharacterHashMap.this.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(int k) {
        return k;
    }

    private Ent _get(int k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsKeyElement(int k) {
        return this._get(k) != null;
    }

    @Override
    public char f(int k) {
        return this._get(k).value;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (IntegerCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
                int b = e.getKey();
                int h = this.getHash(b) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(b, e.getValue());
                    continue;
                }
                ne[h].putEntry(b, Character.valueOf(e.getValue()));
            }
        }
    }

    @Override
    public Character putElement(int k, char v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return null;
        }
        Object r = this.ent[h].putEntry(k, Character.valueOf(v));
        if (r == MARK_A) {
            ++this.size;
            this.resize();
            return null;
        }
        return (Character)r;
    }

    private boolean _putEntry(int k, Character v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v.charValue());
            return true;
        }
        return this.ent[h].putEntry(k, v) != MARK_A;
    }

    private Ent _remove(int k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == this.ent[h].key) {
            Ent r = this.ent[h];
            --this.size;
            this.ent[h] = r.next;
            return r;
        }
        --this.size;
        return this.ent[h].removeEntry(k);
    }

    @Override
    public Character removeElement(int k) {
        Ent r = this._remove(k);
        return r != null ? Character.valueOf(r.value) : null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (IntegerCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            s.writeInt(e.getKey());
            s.writeObject(Character.valueOf(e.getValue()));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            int k = s.readInt();
            Character v = (Character)s.readObject();
            this._putEntry(k, v);
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$2(IntegerCharacterHashMap integerCharacterHashMap) {
        return integerCharacterHashMap.ent;
    }

    private static class Ent
    implements IntegerCharacterMap.PrimitiveEntry {
        private int key;
        private char value;
        private Ent next;

        private Ent(int key, char value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == e.key;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(Integer.toString(this.key)) + "=" + this.value;
        }

        private Ent searchEntry(int k) {
            Ent f = this;
            while (f != null) {
                if (k == f.key) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent removeEntry(int k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Object putEntry(int k, Character v) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    Character r = Character.valueOf(f.value);
                    f.value = v.charValue();
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent(k, v.charValue());
            return MARK_A;
        }

        public int getKey() {
            return this.key;
        }

        public char getValue() {
            return this.value;
        }

        public char setValue(char v) {
            char r = this.value;
            this.value = v;
            return r;
        }
    }
}

