/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.map.pp.AbstractDoubleFloatMap;
import net.morilib.util.primitive.map.pp.DoubleFloatMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleFloatHashMap
extends AbstractDoubleFloatMap
implements Serializable {
    private static final long serialVersionUID = -2524637876889987554L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object MARK_A = new Object();
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<DoubleFloatMap.PrimitiveEntry> entrySet;

    /*
     * Unable to fully structure code
     */
    public DoubleFloatHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl13
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl13:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public DoubleFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleFloatHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public DoubleFloatHashMap() {
        this(16, 0.75f);
    }

    public DoubleFloatHashMap(DoubleFloatMap mp) {
        this(16, 0.75f);
        this.putAllElement(mp);
    }

    private Iterator<DoubleFloatMap.PrimitiveEntry> entrySetIterator() {
        return new Iterator<DoubleFloatMap.PrimitiveEntry>(){
            private int ptr = -1;
            private Ent e = this._next();
            private Ent remove = null;
            private int exModCount;
            {
                this.exModCount = DoubleFloatHashMap.this.modCount;
            }

            /*
             * Unable to fully structure code
             */
            private Ent _next() {
                v0 = this.e = this.ptr < 0 ? null : Ent.access$0(this.e);
                if (this.e == null) ** GOTO lbl6
                return this.e;
lbl-1000:
                // 1 sources

                {
                    if (DoubleFloatHashMap.access$2(DoubleFloatHashMap.this)[this.ptr] == null) continue;
                    return DoubleFloatHashMap.access$2(DoubleFloatHashMap.this)[this.ptr];
lbl6:
                    // 2 sources

                    ** while (++this.ptr < DoubleFloatHashMap.access$2((DoubleFloatHashMap)DoubleFloatHashMap.this).length)
                }
lbl7:
                // 1 sources

                return null;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public DoubleFloatMap.PrimitiveEntry next() {
                this.remove = this.e;
                if (this.e == null) {
                    throw new NoSuchElementException();
                }
                if (this.exModCount != DoubleFloatHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.e = this._next();
                return this.remove;
            }

            @Override
            public void remove() {
                if (this.remove == null) {
                    throw new IllegalStateException();
                }
                DoubleFloatHashMap.this._remove(this.remove.key);
                this.exModCount = DoubleFloatHashMap.this.modCount;
                this.remove = null;
            }
        };
    }

    @Override
    public Set<DoubleFloatMap.PrimitiveEntry> primitiveEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<DoubleFloatMap.PrimitiveEntry>(){

                @Override
                public Iterator<DoubleFloatMap.PrimitiveEntry> iterator() {
                    return DoubleFloatHashMap.this.entrySetIterator();
                }

                @Override
                public int size() {
                    return DoubleFloatHashMap.this.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(double k) {
        return (int)Double.doubleToLongBits(k);
    }

    private Ent _get(double k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsKeyElement(double k) {
        return this._get(k) != null;
    }

    @Override
    public float f(double k) {
        return this._get(k).value;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (DoubleFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
                double b = e.getKey();
                int h = this.getHash(b) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(b, e.getValue());
                    continue;
                }
                ne[h].putEntry(b, Float.valueOf(e.getValue()));
            }
        }
    }

    @Override
    public Float putElement(double k, float v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return null;
        }
        Object r = this.ent[h].putEntry(k, Float.valueOf(v));
        if (r == MARK_A) {
            ++this.size;
            this.resize();
            return null;
        }
        return (Float)r;
    }

    private boolean _putEntry(double k, Float v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v.floatValue());
            return true;
        }
        return this.ent[h].putEntry(k, v) != MARK_A;
    }

    private Ent _remove(double k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == this.ent[h].key) {
            Ent r = this.ent[h];
            --this.size;
            this.ent[h] = r.next;
            return r;
        }
        --this.size;
        return this.ent[h].removeEntry(k);
    }

    @Override
    public Float removeElement(double k) {
        Ent r = this._remove(k);
        return r != null ? Float.valueOf(r.value) : null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (DoubleFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            s.writeDouble(e.getKey());
            s.writeObject(Float.valueOf(e.getValue()));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            double k = s.readDouble();
            Float v = (Float)s.readObject();
            this._putEntry(k, v);
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$2(DoubleFloatHashMap doubleFloatHashMap) {
        return doubleFloatHashMap.ent;
    }

    private static class Ent
    implements DoubleFloatMap.PrimitiveEntry {
        private double key;
        private float value;
        private Ent next;

        private Ent(double key, float value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return (int)this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == e.key;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(Double.toString(this.key)) + "=" + this.value;
        }

        private Ent searchEntry(double k) {
            Ent f = this;
            while (f != null) {
                if (k == f.key) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent removeEntry(double k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Object putEntry(double k, Float v) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    Float r = Float.valueOf(f.value);
                    f.value = v.floatValue();
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent(k, v.floatValue());
            return MARK_A;
        }

        public double getKey() {
            return this.key;
        }

        public float getValue() {
            return this.value;
        }

        public float setValue(float v) {
            float r = this.value;
            this.value = v;
            return r;
        }
    }
}

