/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractLongSet;
import net.morilib.util.primitive.AbstractShortCollection;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.ShortCollection;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.map.op.ShortValueMap;
import net.morilib.util.primitive.map.po.LongMap;
import net.morilib.util.primitive.map.pp.LongShortMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongShortMap
implements LongShortMap {
    private transient LongSet keySet = null;
    private transient ShortCollection values = null;
    private transient Set<LongMap.PrimitiveEntryK<Short>> entrySetK = null;
    private transient Set<ShortValueMap.PrimitiveEntryV<Long>> entrySetV = null;
    private transient Set<Map.Entry<Long, Short>> entrySet = null;

    @Override
    public void clear() {
        Iterator<LongShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(short v) {
        for (LongShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public short f(long k) {
        for (LongShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Short getElement(long k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet longKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(LongShortMap map) {
        for (LongShortMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Short) {
            return this.containsKeyElement((Long)key);
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        if (key instanceof Short) {
            return this.getElement((Long)key);
        }
        return null;
    }

    @Override
    public Short put(Long key, short value) {
        return this.putElement((long)key, value);
    }

    @Override
    public Short remove(Object key) {
        if (key instanceof Short) {
            return this.removeElement((Long)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Short> m) {
        for (Map.Entry<? extends Long, ? extends Short> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongSet keySet() {
        return this.longKeySet();
    }

    @Override
    public Set<Map.Entry<Long, Short>> entrySet() {
        final Set<LongShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Long, Short>>(){

                @Override
                public Iterator<Map.Entry<Long, Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Long, Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Long, Short> next() {
                            final LongShortMap.PrimitiveEntry o = (LongShortMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Long, Short>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(long k) {
        for (LongShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Short get(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((short)k);
    }

    @Override
    public Short put(int k, Short v) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((long)k, v);
    }

    @Override
    public Short removeElement(long k) {
        Iterator<LongShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            LongShortMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            short r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Short remove(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<LongMap.PrimitiveEntryK<Short>> longKeyEntrySet() {
        final Set<LongShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<LongMap.PrimitiveEntryK<Short>>(){

                @Override
                public Iterator<LongMap.PrimitiveEntryK<Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongMap.PrimitiveEntryK<Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongMap.PrimitiveEntryK<Short> next() {
                            final LongShortMap.PrimitiveEntry o = (LongShortMap.PrimitiveEntry)i.next();
                            return new LongMap.PrimitiveEntryK<Short>(){

                                @Override
                                public long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Short putElement(long k, Short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongMap<Short> map) {
        for (LongMap.PrimitiveEntryK<Short> e : map.longKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((short)v);
    }

    @Override
    public Set<ShortValueMap.PrimitiveEntryV<Long>> shortValueEntrySet() {
        final Set<LongShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ShortValueMap.PrimitiveEntryV<Long>>(){

                @Override
                public Iterator<ShortValueMap.PrimitiveEntryV<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ShortValueMap.PrimitiveEntryV<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ShortValueMap.PrimitiveEntryV<Long> next() {
                            final LongShortMap.PrimitiveEntry o = (LongShortMap.PrimitiveEntry)i.next();
                            return new ShortValueMap.PrimitiveEntryV<Long>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public short setValue(short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public short getElement(Object k) {
        if (k instanceof Long) {
            return this.f((Long)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public short putElement(Long k, short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ShortValueMap<Long> map) {
        for (ShortValueMap.PrimitiveEntryV<Long> e : map.shortValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection shortValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Short) {
            return this.containsValueElement((Short)value);
        }
        return false;
    }

    @Override
    public Short put(Long key, Short value) {
        return this.putElement((long)key, (short)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (LongShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof LongShortMap)) break block1;
            m = (LongShortMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (LongShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractLongSet {
        private Set<LongShortMap.PrimitiveEntry> eset;

        private KSet(Set<LongShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<LongShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public long next() {
                    return ((LongShortMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongShortMap.this.size();
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractLongShortMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongShortMap.this.clear();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractShortCollection {
        private Set<LongShortMap.PrimitiveEntry> eset;

        private VCol(Set<LongShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ShortIterator shortIterator() {
            final Iterator<LongShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ShortIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public short next() {
                    return ((LongShortMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongShortMap.this.size();
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsShort(short o) {
            return AbstractLongShortMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongShortMap.this.clear();
        }
    }
}

