/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.AbstractLongSet;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.DoubleValueMap;
import net.morilib.util.primitive.map.po.LongMap;
import net.morilib.util.primitive.map.pp.LongDoubleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongDoubleMap
implements LongDoubleMap {
    private transient LongSet keySet = null;
    private transient DoubleCollection values = null;
    private transient Set<LongMap.PrimitiveEntryK<Double>> entrySetK = null;
    private transient Set<DoubleValueMap.PrimitiveEntryV<Long>> entrySetV = null;
    private transient Set<Map.Entry<Long, Double>> entrySet = null;

    @Override
    public void clear() {
        Iterator<LongDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(double v) {
        for (LongDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public double f(long k) {
        for (LongDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Double getElement(long k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet longKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(LongDoubleMap map) {
        for (LongDoubleMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Double) {
            return this.containsKeyElement((Long)key);
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        if (key instanceof Double) {
            return this.getElement((Long)key);
        }
        return null;
    }

    @Override
    public Double put(Long key, double value) {
        return this.putElement((long)key, value);
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Double) {
            return this.removeElement((Long)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Double> m) {
        for (Map.Entry<? extends Long, ? extends Double> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongSet keySet() {
        return this.longKeySet();
    }

    @Override
    public Set<Map.Entry<Long, Double>> entrySet() {
        final Set<LongDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Long, Double>>(){

                @Override
                public Iterator<Map.Entry<Long, Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Long, Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Long, Double> next() {
                            final LongDoubleMap.PrimitiveEntry o = (LongDoubleMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Long, Double>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(long k) {
        for (LongDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double get(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((Object)k);
    }

    @Override
    public Double put(int k, Double v) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((long)k, v);
    }

    @Override
    public Double removeElement(long k) {
        Iterator<LongDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            LongDoubleMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            double r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Double remove(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<LongMap.PrimitiveEntryK<Double>> longKeyEntrySet() {
        final Set<LongDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<LongMap.PrimitiveEntryK<Double>>(){

                @Override
                public Iterator<LongMap.PrimitiveEntryK<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongMap.PrimitiveEntryK<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongMap.PrimitiveEntryK<Double> next() {
                            final LongDoubleMap.PrimitiveEntry o = (LongDoubleMap.PrimitiveEntry)i.next();
                            return new LongMap.PrimitiveEntryK<Double>(){

                                @Override
                                public long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Double putElement(long k, Double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongMap<Double> map) {
        for (LongMap.PrimitiveEntryK<Double> e : map.longKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<DoubleValueMap.PrimitiveEntryV<Long>> doubleValueEntrySet() {
        final Set<LongDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<DoubleValueMap.PrimitiveEntryV<Long>>(){

                @Override
                public Iterator<DoubleValueMap.PrimitiveEntryV<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleValueMap.PrimitiveEntryV<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleValueMap.PrimitiveEntryV<Long> next() {
                            final LongDoubleMap.PrimitiveEntry o = (LongDoubleMap.PrimitiveEntry)i.next();
                            return new DoubleValueMap.PrimitiveEntryV<Long>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public double setValue(double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public double getElement(Object k) {
        if (k instanceof Long) {
            return this.f((Long)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double putElement(Long k, double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleValueMap<Long> map) {
        for (DoubleValueMap.PrimitiveEntryV<Long> e : map.doubleValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection doubleValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Double) {
            return this.containsValueElement((Double)value);
        }
        return false;
    }

    @Override
    public Double put(Long key, Double value) {
        return this.putElement((long)key, (double)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (LongDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof LongDoubleMap)) break block1;
            m = (LongDoubleMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (LongDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractLongSet {
        private Set<LongDoubleMap.PrimitiveEntry> eset;

        private KSet(Set<LongDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<LongDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public long next() {
                    return ((LongDoubleMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongDoubleMap.this.size();
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractLongDoubleMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongDoubleMap.this.clear();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractDoubleCollection {
        private Set<LongDoubleMap.PrimitiveEntry> eset;

        private VCol(Set<LongDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<LongDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((LongDoubleMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongDoubleMap.this.size();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractLongDoubleMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongDoubleMap.this.clear();
        }
    }
}

