/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.AbstractLongSet;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.ByteValueMap;
import net.morilib.util.primitive.map.po.LongMap;
import net.morilib.util.primitive.map.pp.LongByteMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongByteMap
implements LongByteMap {
    private transient LongSet keySet = null;
    private transient ByteCollection values = null;
    private transient Set<LongMap.PrimitiveEntryK<Byte>> entrySetK = null;
    private transient Set<ByteValueMap.PrimitiveEntryV<Long>> entrySetV = null;
    private transient Set<Map.Entry<Long, Byte>> entrySet = null;

    @Override
    public void clear() {
        Iterator<LongByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(byte v) {
        for (LongByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte f(long k) {
        for (LongByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Byte getElement(long k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet longKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(LongByteMap map) {
        for (LongByteMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Byte) {
            return this.containsKeyElement((Long)key);
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        if (key instanceof Byte) {
            return this.getElement((Long)key);
        }
        return null;
    }

    @Override
    public Byte put(Long key, byte value) {
        return this.putElement((long)key, value);
    }

    @Override
    public Byte remove(Object key) {
        if (key instanceof Byte) {
            return this.removeElement((Long)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Byte> m) {
        for (Map.Entry<? extends Long, ? extends Byte> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongSet keySet() {
        return this.longKeySet();
    }

    @Override
    public Set<Map.Entry<Long, Byte>> entrySet() {
        final Set<LongByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Long, Byte>>(){

                @Override
                public Iterator<Map.Entry<Long, Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Long, Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Long, Byte> next() {
                            final LongByteMap.PrimitiveEntry o = (LongByteMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Long, Byte>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(long k) {
        for (LongByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Byte get(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.getElement((byte)k);
    }

    @Override
    public Byte put(int k, Byte v) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.putElement((long)k, v);
    }

    @Override
    public Byte removeElement(long k) {
        Iterator<LongByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            LongByteMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            byte r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Byte remove(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<LongMap.PrimitiveEntryK<Byte>> longKeyEntrySet() {
        final Set<LongByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<LongMap.PrimitiveEntryK<Byte>>(){

                @Override
                public Iterator<LongMap.PrimitiveEntryK<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongMap.PrimitiveEntryK<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongMap.PrimitiveEntryK<Byte> next() {
                            final LongByteMap.PrimitiveEntry o = (LongByteMap.PrimitiveEntry)i.next();
                            return new LongMap.PrimitiveEntryK<Byte>(){

                                @Override
                                public long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Byte putElement(long k, Byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongMap<Byte> map) {
        for (LongMap.PrimitiveEntryK<Byte> e : map.longKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((byte)v);
    }

    @Override
    public Set<ByteValueMap.PrimitiveEntryV<Long>> byteValueEntrySet() {
        final Set<LongByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ByteValueMap.PrimitiveEntryV<Long>>(){

                @Override
                public Iterator<ByteValueMap.PrimitiveEntryV<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteValueMap.PrimitiveEntryV<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteValueMap.PrimitiveEntryV<Long> next() {
                            final LongByteMap.PrimitiveEntry o = (LongByteMap.PrimitiveEntry)i.next();
                            return new ByteValueMap.PrimitiveEntryV<Long>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public byte setValue(byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public byte getElement(Object k) {
        if (k instanceof Long) {
            return this.f((Long)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public byte putElement(Long k, byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteValueMap<Long> map) {
        for (ByteValueMap.PrimitiveEntryV<Long> e : map.byteValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection byteValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Byte) {
            return this.containsValueElement((Byte)value);
        }
        return false;
    }

    @Override
    public Byte put(Long key, Byte value) {
        return this.putElement((long)key, (byte)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (LongByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof LongByteMap)) break block1;
            m = (LongByteMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (LongByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractLongSet {
        private Set<LongByteMap.PrimitiveEntry> eset;

        private KSet(Set<LongByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<LongByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public long next() {
                    return ((LongByteMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongByteMap.this.size();
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractLongByteMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongByteMap.this.clear();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractByteCollection {
        private Set<LongByteMap.PrimitiveEntry> eset;

        private VCol(Set<LongByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<LongByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((LongByteMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongByteMap.this.size();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractLongByteMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongByteMap.this.clear();
        }
    }
}

