/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.AbstractIntegerSet;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.DoubleValueMap;
import net.morilib.util.primitive.map.po.IntegerMap;
import net.morilib.util.primitive.map.pp.IntegerDoubleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegerDoubleMap
implements IntegerDoubleMap {
    private transient IntegerSet keySet = null;
    private transient DoubleCollection values = null;
    private transient Set<IntegerMap.PrimitiveEntryK<Double>> entrySetK = null;
    private transient Set<DoubleValueMap.PrimitiveEntryV<Integer>> entrySetV = null;
    private transient Set<Map.Entry<Integer, Double>> entrySet = null;

    @Override
    public void clear() {
        Iterator<IntegerDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(double v) {
        for (IntegerDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public double f(int k) {
        for (IntegerDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Double getElement(int k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntegerSet intKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(IntegerDoubleMap map) {
        for (IntegerDoubleMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Double) {
            return this.containsKeyElement((Integer)key);
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        if (key instanceof Double) {
            return this.getElement((Integer)key);
        }
        return null;
    }

    @Override
    public Double put(Integer key, double value) {
        return this.putElement((int)key, value);
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Double) {
            return this.removeElement((Integer)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Double> m) {
        for (Map.Entry<? extends Integer, ? extends Double> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerSet keySet() {
        return this.intKeySet();
    }

    @Override
    public Set<Map.Entry<Integer, Double>> entrySet() {
        final Set<IntegerDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, Double>>(){

                @Override
                public Iterator<Map.Entry<Integer, Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Integer, Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Integer, Double> next() {
                            final IntegerDoubleMap.PrimitiveEntry o = (IntegerDoubleMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Integer, Double>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(int k) {
        for (IntegerDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double get(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((Object)k);
    }

    @Override
    public Double put(int k, Double v) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public Double removeElement(int k) {
        Iterator<IntegerDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            IntegerDoubleMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            double r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Double remove(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<IntegerMap.PrimitiveEntryK<Double>> intKeyEntrySet() {
        final Set<IntegerDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<IntegerMap.PrimitiveEntryK<Double>>(){

                @Override
                public Iterator<IntegerMap.PrimitiveEntryK<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerMap.PrimitiveEntryK<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerMap.PrimitiveEntryK<Double> next() {
                            final IntegerDoubleMap.PrimitiveEntry o = (IntegerDoubleMap.PrimitiveEntry)i.next();
                            return new IntegerMap.PrimitiveEntryK<Double>(){

                                @Override
                                public int getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Double putElement(int k, Double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerMap<Double> map) {
        for (IntegerMap.PrimitiveEntryK<Double> e : map.intKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<DoubleValueMap.PrimitiveEntryV<Integer>> doubleValueEntrySet() {
        final Set<IntegerDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<DoubleValueMap.PrimitiveEntryV<Integer>>(){

                @Override
                public Iterator<DoubleValueMap.PrimitiveEntryV<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleValueMap.PrimitiveEntryV<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleValueMap.PrimitiveEntryV<Integer> next() {
                            final IntegerDoubleMap.PrimitiveEntry o = (IntegerDoubleMap.PrimitiveEntry)i.next();
                            return new DoubleValueMap.PrimitiveEntryV<Integer>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public double setValue(double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public double getElement(Object k) {
        if (k instanceof Integer) {
            return this.f((Integer)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double putElement(Integer k, double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleValueMap<Integer> map) {
        for (DoubleValueMap.PrimitiveEntryV<Integer> e : map.doubleValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection doubleValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Double) {
            return this.containsValueElement((Double)value);
        }
        return false;
    }

    @Override
    public Double put(Integer key, Double value) {
        return this.putElement((int)key, (double)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (IntegerDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof IntegerDoubleMap)) break block1;
            m = (IntegerDoubleMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (IntegerDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractIntegerSet {
        private Set<IntegerDoubleMap.PrimitiveEntry> eset;

        private KSet(Set<IntegerDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<IntegerDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public int next() {
                    return ((IntegerDoubleMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerDoubleMap.this.size();
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractIntegerDoubleMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerDoubleMap.this.clear();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractDoubleCollection {
        private Set<IntegerDoubleMap.PrimitiveEntry> eset;

        private VCol(Set<IntegerDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<IntegerDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((IntegerDoubleMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerDoubleMap.this.size();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractIntegerDoubleMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerDoubleMap.this.clear();
        }
    }
}

