/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.AbstractIntegerSet;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.ByteValueMap;
import net.morilib.util.primitive.map.po.IntegerMap;
import net.morilib.util.primitive.map.pp.IntegerByteMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegerByteMap
implements IntegerByteMap {
    private transient IntegerSet keySet = null;
    private transient ByteCollection values = null;
    private transient Set<IntegerMap.PrimitiveEntryK<Byte>> entrySetK = null;
    private transient Set<ByteValueMap.PrimitiveEntryV<Integer>> entrySetV = null;
    private transient Set<Map.Entry<Integer, Byte>> entrySet = null;

    @Override
    public void clear() {
        Iterator<IntegerByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(byte v) {
        for (IntegerByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte f(int k) {
        for (IntegerByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Byte getElement(int k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntegerSet intKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(IntegerByteMap map) {
        for (IntegerByteMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Byte) {
            return this.containsKeyElement((Integer)key);
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        if (key instanceof Byte) {
            return this.getElement((Integer)key);
        }
        return null;
    }

    @Override
    public Byte put(Integer key, byte value) {
        return this.putElement((int)key, value);
    }

    @Override
    public Byte remove(Object key) {
        if (key instanceof Byte) {
            return this.removeElement((Integer)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Byte> m) {
        for (Map.Entry<? extends Integer, ? extends Byte> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerSet keySet() {
        return this.intKeySet();
    }

    @Override
    public Set<Map.Entry<Integer, Byte>> entrySet() {
        final Set<IntegerByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, Byte>>(){

                @Override
                public Iterator<Map.Entry<Integer, Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Integer, Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Integer, Byte> next() {
                            final IntegerByteMap.PrimitiveEntry o = (IntegerByteMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Integer, Byte>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(int k) {
        for (IntegerByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Byte get(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.getElement((byte)k);
    }

    @Override
    public Byte put(int k, Byte v) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public Byte removeElement(int k) {
        Iterator<IntegerByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            IntegerByteMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            byte r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Byte remove(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<IntegerMap.PrimitiveEntryK<Byte>> intKeyEntrySet() {
        final Set<IntegerByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<IntegerMap.PrimitiveEntryK<Byte>>(){

                @Override
                public Iterator<IntegerMap.PrimitiveEntryK<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerMap.PrimitiveEntryK<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerMap.PrimitiveEntryK<Byte> next() {
                            final IntegerByteMap.PrimitiveEntry o = (IntegerByteMap.PrimitiveEntry)i.next();
                            return new IntegerMap.PrimitiveEntryK<Byte>(){

                                @Override
                                public int getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Byte putElement(int k, Byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerMap<Byte> map) {
        for (IntegerMap.PrimitiveEntryK<Byte> e : map.intKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((byte)v);
    }

    @Override
    public Set<ByteValueMap.PrimitiveEntryV<Integer>> byteValueEntrySet() {
        final Set<IntegerByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ByteValueMap.PrimitiveEntryV<Integer>>(){

                @Override
                public Iterator<ByteValueMap.PrimitiveEntryV<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteValueMap.PrimitiveEntryV<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteValueMap.PrimitiveEntryV<Integer> next() {
                            final IntegerByteMap.PrimitiveEntry o = (IntegerByteMap.PrimitiveEntry)i.next();
                            return new ByteValueMap.PrimitiveEntryV<Integer>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public byte setValue(byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public byte getElement(Object k) {
        if (k instanceof Integer) {
            return this.f((Integer)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public byte putElement(Integer k, byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteValueMap<Integer> map) {
        for (ByteValueMap.PrimitiveEntryV<Integer> e : map.byteValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection byteValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Byte) {
            return this.containsValueElement((Byte)value);
        }
        return false;
    }

    @Override
    public Byte put(Integer key, Byte value) {
        return this.putElement((int)key, (byte)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (IntegerByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof IntegerByteMap)) break block1;
            m = (IntegerByteMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (IntegerByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractIntegerSet {
        private Set<IntegerByteMap.PrimitiveEntry> eset;

        private KSet(Set<IntegerByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<IntegerByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public int next() {
                    return ((IntegerByteMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerByteMap.this.size();
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractIntegerByteMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerByteMap.this.clear();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractByteCollection {
        private Set<IntegerByteMap.PrimitiveEntry> eset;

        private VCol(Set<IntegerByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<IntegerByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((IntegerByteMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerByteMap.this.size();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractIntegerByteMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerByteMap.this.clear();
        }
    }
}

