/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractFloatSet;
import net.morilib.util.primitive.AbstractShortCollection;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.ShortCollection;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.map.op.ShortValueMap;
import net.morilib.util.primitive.map.po.FloatMap;
import net.morilib.util.primitive.map.pp.FloatShortMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatShortMap
implements FloatShortMap {
    private transient FloatSet keySet = null;
    private transient ShortCollection values = null;
    private transient Set<FloatMap.PrimitiveEntryK<Short>> entrySetK = null;
    private transient Set<ShortValueMap.PrimitiveEntryV<Float>> entrySetV = null;
    private transient Set<Map.Entry<Float, Short>> entrySet = null;

    @Override
    public void clear() {
        Iterator<FloatShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(short v) {
        for (FloatShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public short f(float k) {
        for (FloatShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Short getElement(float k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet floatKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(FloatShortMap map) {
        for (FloatShortMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Short) {
            return this.containsKeyElement(((Float)key).floatValue());
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        if (key instanceof Short) {
            return this.getElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public Short put(Float key, short value) {
        return this.putElement(key.floatValue(), value);
    }

    @Override
    public Short remove(Object key) {
        if (key instanceof Short) {
            return this.removeElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Short> m) {
        for (Map.Entry<? extends Float, ? extends Short> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatSet keySet() {
        return this.floatKeySet();
    }

    @Override
    public Set<Map.Entry<Float, Short>> entrySet() {
        final Set<FloatShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Float, Short>>(){

                @Override
                public Iterator<Map.Entry<Float, Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Float, Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Float, Short> next() {
                            final FloatShortMap.PrimitiveEntry o = (FloatShortMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Float, Short>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(float k) {
        for (FloatShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Short get(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((short)k);
    }

    @Override
    public Short put(int k, Short v) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((float)k, v);
    }

    @Override
    public Short removeElement(float k) {
        Iterator<FloatShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            FloatShortMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            short r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Short remove(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<FloatMap.PrimitiveEntryK<Short>> floatKeyEntrySet() {
        final Set<FloatShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<FloatMap.PrimitiveEntryK<Short>>(){

                @Override
                public Iterator<FloatMap.PrimitiveEntryK<Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatMap.PrimitiveEntryK<Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatMap.PrimitiveEntryK<Short> next() {
                            final FloatShortMap.PrimitiveEntry o = (FloatShortMap.PrimitiveEntry)i.next();
                            return new FloatMap.PrimitiveEntryK<Short>(){

                                @Override
                                public float getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Short putElement(float k, Short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatMap<Short> map) {
        for (FloatMap.PrimitiveEntryK<Short> e : map.floatKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((short)v);
    }

    @Override
    public Set<ShortValueMap.PrimitiveEntryV<Float>> shortValueEntrySet() {
        final Set<FloatShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ShortValueMap.PrimitiveEntryV<Float>>(){

                @Override
                public Iterator<ShortValueMap.PrimitiveEntryV<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ShortValueMap.PrimitiveEntryV<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ShortValueMap.PrimitiveEntryV<Float> next() {
                            final FloatShortMap.PrimitiveEntry o = (FloatShortMap.PrimitiveEntry)i.next();
                            return new ShortValueMap.PrimitiveEntryV<Float>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public short setValue(short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public short getElement(Object k) {
        if (k instanceof Float) {
            return this.f(((Float)k).floatValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public short putElement(Float k, short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ShortValueMap<Float> map) {
        for (ShortValueMap.PrimitiveEntryV<Float> e : map.shortValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection shortValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Short) {
            return this.containsValueElement((Short)value);
        }
        return false;
    }

    @Override
    public Short put(Float key, Short value) {
        return this.putElement(key.floatValue(), (short)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatShortMap)) break block1;
            m = (FloatShortMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractFloatSet {
        private Set<FloatShortMap.PrimitiveEntry> eset;

        private KSet(Set<FloatShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<FloatShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public float next() {
                    return ((FloatShortMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatShortMap.this.size();
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractFloatShortMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatShortMap.this.clear();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractShortCollection {
        private Set<FloatShortMap.PrimitiveEntry> eset;

        private VCol(Set<FloatShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ShortIterator shortIterator() {
            final Iterator<FloatShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ShortIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public short next() {
                    return ((FloatShortMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatShortMap.this.size();
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsShort(short o) {
            return AbstractFloatShortMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatShortMap.this.clear();
        }
    }
}

