/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractFloatSet;
import net.morilib.util.primitive.AbstractIntegerCollection;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.IntegerValueMap;
import net.morilib.util.primitive.map.po.FloatMap;
import net.morilib.util.primitive.map.pp.FloatIntegerMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatIntegerMap
implements FloatIntegerMap {
    private transient FloatSet keySet = null;
    private transient IntegerCollection values = null;
    private transient Set<FloatMap.PrimitiveEntryK<Integer>> entrySetK = null;
    private transient Set<IntegerValueMap.PrimitiveEntryV<Float>> entrySetV = null;
    private transient Set<Map.Entry<Float, Integer>> entrySet = null;

    @Override
    public void clear() {
        Iterator<FloatIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(int v) {
        for (FloatIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public int f(float k) {
        for (FloatIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Integer getElement(float k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet floatKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(FloatIntegerMap map) {
        for (FloatIntegerMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKeyElement(((Float)key).floatValue());
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        if (key instanceof Integer) {
            return this.getElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public Integer put(Float key, int value) {
        return this.putElement(key.floatValue(), value);
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof Integer) {
            return this.removeElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Integer> m) {
        for (Map.Entry<? extends Float, ? extends Integer> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatSet keySet() {
        return this.floatKeySet();
    }

    @Override
    public Set<Map.Entry<Float, Integer>> entrySet() {
        final Set<FloatIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Float, Integer>>(){

                @Override
                public Iterator<Map.Entry<Float, Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Float, Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Float, Integer> next() {
                            final FloatIntegerMap.PrimitiveEntry o = (FloatIntegerMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Float, Integer>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(float k) {
        for (FloatIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer get(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Integer put(int k, Integer v) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((float)k, v);
    }

    @Override
    public Integer removeElement(float k) {
        Iterator<FloatIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            FloatIntegerMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            int r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Integer remove(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<FloatMap.PrimitiveEntryK<Integer>> floatKeyEntrySet() {
        final Set<FloatIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<FloatMap.PrimitiveEntryK<Integer>>(){

                @Override
                public Iterator<FloatMap.PrimitiveEntryK<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatMap.PrimitiveEntryK<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatMap.PrimitiveEntryK<Integer> next() {
                            final FloatIntegerMap.PrimitiveEntry o = (FloatIntegerMap.PrimitiveEntry)i.next();
                            return new FloatMap.PrimitiveEntryK<Integer>(){

                                @Override
                                public float getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Integer putElement(float k, Integer v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatMap<Integer> map) {
        for (FloatMap.PrimitiveEntryK<Integer> e : map.floatKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<IntegerValueMap.PrimitiveEntryV<Float>> intValueEntrySet() {
        final Set<FloatIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<IntegerValueMap.PrimitiveEntryV<Float>>(){

                @Override
                public Iterator<IntegerValueMap.PrimitiveEntryV<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerValueMap.PrimitiveEntryV<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerValueMap.PrimitiveEntryV<Float> next() {
                            final FloatIntegerMap.PrimitiveEntry o = (FloatIntegerMap.PrimitiveEntry)i.next();
                            return new IntegerValueMap.PrimitiveEntryV<Float>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public int getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public int setValue(int value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public int getElement(Object k) {
        if (k instanceof Float) {
            return this.f(((Float)k).floatValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int putElement(Float k, int v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerValueMap<Float> map) {
        for (IntegerValueMap.PrimitiveEntryV<Float> e : map.intValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection intValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            return this.containsValueElement((Integer)value);
        }
        return false;
    }

    @Override
    public Integer put(Float key, Integer value) {
        return this.putElement(key.floatValue(), (int)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatIntegerMap)) break block1;
            m = (FloatIntegerMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractFloatSet {
        private Set<FloatIntegerMap.PrimitiveEntry> eset;

        private KSet(Set<FloatIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<FloatIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public float next() {
                    return ((FloatIntegerMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatIntegerMap.this.size();
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractFloatIntegerMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatIntegerMap.this.clear();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractIntegerCollection {
        private Set<FloatIntegerMap.PrimitiveEntry> eset;

        private VCol(Set<FloatIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<FloatIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public int next() {
                    return ((FloatIntegerMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatIntegerMap.this.size();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractFloatIntegerMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatIntegerMap.this.clear();
        }
    }
}

