/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.AbstractFloatSet;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.op.DoubleValueMap;
import net.morilib.util.primitive.map.po.FloatMap;
import net.morilib.util.primitive.map.pp.FloatDoubleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatDoubleMap
implements FloatDoubleMap {
    private transient FloatSet keySet = null;
    private transient DoubleCollection values = null;
    private transient Set<FloatMap.PrimitiveEntryK<Double>> entrySetK = null;
    private transient Set<DoubleValueMap.PrimitiveEntryV<Float>> entrySetV = null;
    private transient Set<Map.Entry<Float, Double>> entrySet = null;

    @Override
    public void clear() {
        Iterator<FloatDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(double v) {
        for (FloatDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public double f(float k) {
        for (FloatDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Double getElement(float k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet floatKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(FloatDoubleMap map) {
        for (FloatDoubleMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Double) {
            return this.containsKeyElement(((Float)key).floatValue());
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        if (key instanceof Double) {
            return this.getElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public Double put(Float key, double value) {
        return this.putElement(key.floatValue(), value);
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Double) {
            return this.removeElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Double> m) {
        for (Map.Entry<? extends Float, ? extends Double> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatSet keySet() {
        return this.floatKeySet();
    }

    @Override
    public Set<Map.Entry<Float, Double>> entrySet() {
        final Set<FloatDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Float, Double>>(){

                @Override
                public Iterator<Map.Entry<Float, Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Float, Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Float, Double> next() {
                            final FloatDoubleMap.PrimitiveEntry o = (FloatDoubleMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Float, Double>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(float k) {
        for (FloatDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double get(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((Object)k);
    }

    @Override
    public Double put(int k, Double v) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((float)k, v);
    }

    @Override
    public Double removeElement(float k) {
        Iterator<FloatDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            FloatDoubleMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            double r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Double remove(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<FloatMap.PrimitiveEntryK<Double>> floatKeyEntrySet() {
        final Set<FloatDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<FloatMap.PrimitiveEntryK<Double>>(){

                @Override
                public Iterator<FloatMap.PrimitiveEntryK<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatMap.PrimitiveEntryK<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatMap.PrimitiveEntryK<Double> next() {
                            final FloatDoubleMap.PrimitiveEntry o = (FloatDoubleMap.PrimitiveEntry)i.next();
                            return new FloatMap.PrimitiveEntryK<Double>(){

                                @Override
                                public float getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Double putElement(float k, Double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatMap<Double> map) {
        for (FloatMap.PrimitiveEntryK<Double> e : map.floatKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<DoubleValueMap.PrimitiveEntryV<Float>> doubleValueEntrySet() {
        final Set<FloatDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<DoubleValueMap.PrimitiveEntryV<Float>>(){

                @Override
                public Iterator<DoubleValueMap.PrimitiveEntryV<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleValueMap.PrimitiveEntryV<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleValueMap.PrimitiveEntryV<Float> next() {
                            final FloatDoubleMap.PrimitiveEntry o = (FloatDoubleMap.PrimitiveEntry)i.next();
                            return new DoubleValueMap.PrimitiveEntryV<Float>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public double setValue(double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public double getElement(Object k) {
        if (k instanceof Float) {
            return this.f(((Float)k).floatValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double putElement(Float k, double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleValueMap<Float> map) {
        for (DoubleValueMap.PrimitiveEntryV<Float> e : map.doubleValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection doubleValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Double) {
            return this.containsValueElement((Double)value);
        }
        return false;
    }

    @Override
    public Double put(Float key, Double value) {
        return this.putElement(key.floatValue(), (double)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatDoubleMap)) break block1;
            m = (FloatDoubleMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractFloatSet {
        private Set<FloatDoubleMap.PrimitiveEntry> eset;

        private KSet(Set<FloatDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<FloatDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public float next() {
                    return ((FloatDoubleMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatDoubleMap.this.size();
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractFloatDoubleMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatDoubleMap.this.clear();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractDoubleCollection {
        private Set<FloatDoubleMap.PrimitiveEntry> eset;

        private VCol(Set<FloatDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<FloatDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((FloatDoubleMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatDoubleMap.this.size();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractFloatDoubleMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatDoubleMap.this.clear();
        }
    }
}

