/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.AbstractFloatSet;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.op.ByteValueMap;
import net.morilib.util.primitive.map.po.FloatMap;
import net.morilib.util.primitive.map.pp.FloatByteMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatByteMap
implements FloatByteMap {
    private transient FloatSet keySet = null;
    private transient ByteCollection values = null;
    private transient Set<FloatMap.PrimitiveEntryK<Byte>> entrySetK = null;
    private transient Set<ByteValueMap.PrimitiveEntryV<Float>> entrySetV = null;
    private transient Set<Map.Entry<Float, Byte>> entrySet = null;

    @Override
    public void clear() {
        Iterator<FloatByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(byte v) {
        for (FloatByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte f(float k) {
        for (FloatByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Byte getElement(float k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet floatKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(FloatByteMap map) {
        for (FloatByteMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Byte) {
            return this.containsKeyElement(((Float)key).floatValue());
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        if (key instanceof Byte) {
            return this.getElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public Byte put(Float key, byte value) {
        return this.putElement(key.floatValue(), value);
    }

    @Override
    public Byte remove(Object key) {
        if (key instanceof Byte) {
            return this.removeElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Byte> m) {
        for (Map.Entry<? extends Float, ? extends Byte> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatSet keySet() {
        return this.floatKeySet();
    }

    @Override
    public Set<Map.Entry<Float, Byte>> entrySet() {
        final Set<FloatByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Float, Byte>>(){

                @Override
                public Iterator<Map.Entry<Float, Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Float, Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Float, Byte> next() {
                            final FloatByteMap.PrimitiveEntry o = (FloatByteMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Float, Byte>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(float k) {
        for (FloatByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Byte get(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.getElement((byte)k);
    }

    @Override
    public Byte put(int k, Byte v) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.putElement((float)k, v);
    }

    @Override
    public Byte removeElement(float k) {
        Iterator<FloatByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            FloatByteMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            byte r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Byte remove(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<FloatMap.PrimitiveEntryK<Byte>> floatKeyEntrySet() {
        final Set<FloatByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<FloatMap.PrimitiveEntryK<Byte>>(){

                @Override
                public Iterator<FloatMap.PrimitiveEntryK<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatMap.PrimitiveEntryK<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatMap.PrimitiveEntryK<Byte> next() {
                            final FloatByteMap.PrimitiveEntry o = (FloatByteMap.PrimitiveEntry)i.next();
                            return new FloatMap.PrimitiveEntryK<Byte>(){

                                @Override
                                public float getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Byte putElement(float k, Byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatMap<Byte> map) {
        for (FloatMap.PrimitiveEntryK<Byte> e : map.floatKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((byte)v);
    }

    @Override
    public Set<ByteValueMap.PrimitiveEntryV<Float>> byteValueEntrySet() {
        final Set<FloatByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ByteValueMap.PrimitiveEntryV<Float>>(){

                @Override
                public Iterator<ByteValueMap.PrimitiveEntryV<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteValueMap.PrimitiveEntryV<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteValueMap.PrimitiveEntryV<Float> next() {
                            final FloatByteMap.PrimitiveEntry o = (FloatByteMap.PrimitiveEntry)i.next();
                            return new ByteValueMap.PrimitiveEntryV<Float>(){

                                @Override
                                public Float getKey() {
                                    return Float.valueOf(o.getKey());
                                }

                                @Override
                                public byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public byte setValue(byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public byte getElement(Object k) {
        if (k instanceof Float) {
            return this.f(((Float)k).floatValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public byte putElement(Float k, byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteValueMap<Float> map) {
        for (ByteValueMap.PrimitiveEntryV<Float> e : map.byteValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection byteValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Byte) {
            return this.containsValueElement((Byte)value);
        }
        return false;
    }

    @Override
    public Byte put(Float key, Byte value) {
        return this.putElement(key.floatValue(), (byte)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatByteMap)) break block1;
            m = (FloatByteMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractFloatSet {
        private Set<FloatByteMap.PrimitiveEntry> eset;

        private KSet(Set<FloatByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<FloatByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public float next() {
                    return ((FloatByteMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatByteMap.this.size();
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractFloatByteMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatByteMap.this.clear();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractByteCollection {
        private Set<FloatByteMap.PrimitiveEntry> eset;

        private VCol(Set<FloatByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<FloatByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((FloatByteMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatByteMap.this.size();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractFloatByteMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatByteMap.this.clear();
        }
    }
}

