/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleSet;
import net.morilib.util.primitive.AbstractLongCollection;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.LongCollection;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.LongValueMap;
import net.morilib.util.primitive.map.po.DoubleMap;
import net.morilib.util.primitive.map.pp.DoubleLongMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleLongMap
implements DoubleLongMap {
    private transient DoubleSet keySet = null;
    private transient LongCollection values = null;
    private transient Set<DoubleMap.PrimitiveEntryK<Long>> entrySetK = null;
    private transient Set<LongValueMap.PrimitiveEntryV<Double>> entrySetV = null;
    private transient Set<Map.Entry<Double, Long>> entrySet = null;

    @Override
    public void clear() {
        Iterator<DoubleLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(long v) {
        for (DoubleLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public long f(double k) {
        for (DoubleLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Long getElement(double k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet doubleKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(DoubleLongMap map) {
        for (DoubleLongMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return this.containsKeyElement((Double)key);
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        if (key instanceof Long) {
            return this.getElement((Double)key);
        }
        return null;
    }

    @Override
    public Long put(Double key, long value) {
        return this.putElement((double)key, value);
    }

    @Override
    public Long remove(Object key) {
        if (key instanceof Long) {
            return this.removeElement((Double)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Long> m) {
        for (Map.Entry<? extends Double, ? extends Long> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleSet keySet() {
        return this.doubleKeySet();
    }

    @Override
    public Set<Map.Entry<Double, Long>> entrySet() {
        final Set<DoubleLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Double, Long>>(){

                @Override
                public Iterator<Map.Entry<Double, Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Double, Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Double, Long> next() {
                            final DoubleLongMap.PrimitiveEntry o = (DoubleLongMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Double, Long>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(double k) {
        for (DoubleLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Long get(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Long put(int k, Long v) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((double)k, v);
    }

    @Override
    public Long removeElement(double k) {
        Iterator<DoubleLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            DoubleLongMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            long r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Long remove(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<DoubleMap.PrimitiveEntryK<Long>> doubleKeyEntrySet() {
        final Set<DoubleLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<DoubleMap.PrimitiveEntryK<Long>>(){

                @Override
                public Iterator<DoubleMap.PrimitiveEntryK<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleMap.PrimitiveEntryK<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleMap.PrimitiveEntryK<Long> next() {
                            final DoubleLongMap.PrimitiveEntry o = (DoubleLongMap.PrimitiveEntry)i.next();
                            return new DoubleMap.PrimitiveEntryK<Long>(){

                                @Override
                                public double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Long putElement(double k, Long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleMap<Long> map) {
        for (DoubleMap.PrimitiveEntryK<Long> e : map.doubleKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<LongValueMap.PrimitiveEntryV<Double>> longValueEntrySet() {
        final Set<DoubleLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<LongValueMap.PrimitiveEntryV<Double>>(){

                @Override
                public Iterator<LongValueMap.PrimitiveEntryV<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongValueMap.PrimitiveEntryV<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongValueMap.PrimitiveEntryV<Double> next() {
                            final DoubleLongMap.PrimitiveEntry o = (DoubleLongMap.PrimitiveEntry)i.next();
                            return new LongValueMap.PrimitiveEntryV<Double>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public long setValue(long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public long getElement(Object k) {
        if (k instanceof Double) {
            return this.f((Double)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long putElement(Double k, long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongValueMap<Double> map) {
        for (LongValueMap.PrimitiveEntryV<Double> e : map.longValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection longValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Long) {
            return this.containsValueElement((Long)value);
        }
        return false;
    }

    @Override
    public Long put(Double key, Long value) {
        return this.putElement((double)key, (long)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (DoubleLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof DoubleLongMap)) break block1;
            m = (DoubleLongMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (DoubleLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractDoubleSet {
        private Set<DoubleLongMap.PrimitiveEntry> eset;

        private KSet(Set<DoubleLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<DoubleLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((DoubleLongMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleLongMap.this.size();
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractDoubleLongMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleLongMap.this.clear();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractLongCollection {
        private Set<DoubleLongMap.PrimitiveEntry> eset;

        private VCol(Set<DoubleLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<DoubleLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public long next() {
                    return ((DoubleLongMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleLongMap.this.size();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractDoubleLongMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleLongMap.this.clear();
        }
    }
}

