/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.AbstractDoubleSet;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.map.op.DoubleValueMap;
import net.morilib.util.primitive.map.po.DoubleMap;
import net.morilib.util.primitive.map.pp.DoubleDoubleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleDoubleMap
implements DoubleDoubleMap {
    private transient DoubleSet keySet = null;
    private transient DoubleCollection values = null;
    private transient Set<DoubleMap.PrimitiveEntryK<Double>> entrySetK = null;
    private transient Set<DoubleValueMap.PrimitiveEntryV<Double>> entrySetV = null;
    private transient Set<Map.Entry<Double, Double>> entrySet = null;

    @Override
    public void clear() {
        Iterator<DoubleDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(double v) {
        for (DoubleDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public double f(double k) {
        for (DoubleDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Double getElement(double k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet doubleKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(DoubleDoubleMap map) {
        for (DoubleDoubleMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Double) {
            return this.containsKeyElement((Double)key);
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        if (key instanceof Double) {
            return this.getElement((Double)key);
        }
        return null;
    }

    @Override
    public Double put(Double key, double value) {
        return this.putElement((double)key, value);
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Double) {
            return this.removeElement((Double)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Double> m) {
        for (Map.Entry<? extends Double, ? extends Double> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleSet keySet() {
        return this.doubleKeySet();
    }

    @Override
    public Set<Map.Entry<Double, Double>> entrySet() {
        final Set<DoubleDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Double, Double>>(){

                @Override
                public Iterator<Map.Entry<Double, Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Double, Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Double, Double> next() {
                            final DoubleDoubleMap.PrimitiveEntry o = (DoubleDoubleMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Double, Double>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(double k) {
        for (DoubleDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double get(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Double put(int k, Double v) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((double)k, v);
    }

    @Override
    public Double removeElement(double k) {
        Iterator<DoubleDoubleMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            DoubleDoubleMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            double r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Double remove(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<DoubleMap.PrimitiveEntryK<Double>> doubleKeyEntrySet() {
        final Set<DoubleDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<DoubleMap.PrimitiveEntryK<Double>>(){

                @Override
                public Iterator<DoubleMap.PrimitiveEntryK<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleMap.PrimitiveEntryK<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleMap.PrimitiveEntryK<Double> next() {
                            final DoubleDoubleMap.PrimitiveEntry o = (DoubleDoubleMap.PrimitiveEntry)i.next();
                            return new DoubleMap.PrimitiveEntryK<Double>(){

                                @Override
                                public double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Double setValue(Double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Double putElement(double k, Double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleMap<Double> map) {
        for (DoubleMap.PrimitiveEntryK<Double> e : map.doubleKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<DoubleValueMap.PrimitiveEntryV<Double>> doubleValueEntrySet() {
        final Set<DoubleDoubleMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<DoubleValueMap.PrimitiveEntryV<Double>>(){

                @Override
                public Iterator<DoubleValueMap.PrimitiveEntryV<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleValueMap.PrimitiveEntryV<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleValueMap.PrimitiveEntryV<Double> next() {
                            final DoubleDoubleMap.PrimitiveEntry o = (DoubleDoubleMap.PrimitiveEntry)i.next();
                            return new DoubleValueMap.PrimitiveEntryV<Double>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public double getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public double setValue(double value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public double getElement(Object k) {
        if (k instanceof Double) {
            return this.f((Double)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double putElement(Double k, double v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleValueMap<Double> map) {
        for (DoubleValueMap.PrimitiveEntryV<Double> e : map.doubleValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleCollection doubleValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Double) {
            return this.containsValueElement((Double)value);
        }
        return false;
    }

    @Override
    public Double put(Double key, Double value) {
        return this.putElement((double)key, (double)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (DoubleDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof DoubleDoubleMap)) break block1;
            m = (DoubleDoubleMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (DoubleDoubleMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractDoubleSet {
        private Set<DoubleDoubleMap.PrimitiveEntry> eset;

        private KSet(Set<DoubleDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<DoubleDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((DoubleDoubleMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleDoubleMap.this.size();
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractDoubleDoubleMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleDoubleMap.this.clear();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractDoubleCollection {
        private Set<DoubleDoubleMap.PrimitiveEntry> eset;

        private VCol(Set<DoubleDoubleMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<DoubleDoubleMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((DoubleDoubleMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleDoubleMap.this.size();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractDoubleDoubleMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleDoubleMap.this.clear();
        }
    }
}

