/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractCharacterSet;
import net.morilib.util.primitive.AbstractFloatCollection;
import net.morilib.util.primitive.CharacterSet;
import net.morilib.util.primitive.FloatCollection;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.op.FloatValueMap;
import net.morilib.util.primitive.map.po.CharacterMap;
import net.morilib.util.primitive.map.pp.CharacterFloatMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharacterFloatMap
implements CharacterFloatMap {
    private transient CharacterSet keySet = null;
    private transient FloatCollection values = null;
    private transient Set<CharacterMap.PrimitiveEntryK<Float>> entrySetK = null;
    private transient Set<FloatValueMap.PrimitiveEntryV<Character>> entrySetV = null;
    private transient Set<Map.Entry<Character, Float>> entrySet = null;

    @Override
    public void clear() {
        Iterator<CharacterFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(float v) {
        for (CharacterFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public float f(char k) {
        for (CharacterFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Float getElement(char k) {
        return Float.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharacterSet charKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(CharacterFloatMap map) {
        for (CharacterFloatMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Float) {
            return this.containsKeyElement(((Character)key).charValue());
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        if (key instanceof Float) {
            return this.getElement(((Character)key).charValue());
        }
        return null;
    }

    @Override
    public Float put(Character key, float value) {
        return this.putElement(key.charValue(), value);
    }

    @Override
    public Float remove(Object key) {
        if (key instanceof Float) {
            return this.removeElement(((Character)key).charValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Float> m) {
        for (Map.Entry<? extends Character, ? extends Float> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterSet keySet() {
        return this.charKeySet();
    }

    @Override
    public Set<Map.Entry<Character, Float>> entrySet() {
        final Set<CharacterFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Character, Float>>(){

                @Override
                public Iterator<Map.Entry<Character, Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Character, Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Character, Float> next() {
                            final CharacterFloatMap.PrimitiveEntry o = (CharacterFloatMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Character, Float>(){

                                @Override
                                public Character getKey() {
                                    return Character.valueOf(o.getKey());
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((char)k);
    }

    @Override
    public boolean containsKeyElement(char k) {
        for (CharacterFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float get(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return Float.valueOf(this.getElement(Float.valueOf(k)));
    }

    @Override
    public Float put(int k, Float v) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((char)k, v);
    }

    @Override
    public Float removeElement(char k) {
        Iterator<CharacterFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            CharacterFloatMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            float r = e.getValue();
            i.remove();
            return Float.valueOf(r);
        }
        return null;
    }

    @Override
    public Float remove(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((char)k);
    }

    @Override
    public Set<CharacterMap.PrimitiveEntryK<Float>> charKeyEntrySet() {
        final Set<CharacterFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<CharacterMap.PrimitiveEntryK<Float>>(){

                @Override
                public Iterator<CharacterMap.PrimitiveEntryK<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<CharacterMap.PrimitiveEntryK<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public CharacterMap.PrimitiveEntryK<Float> next() {
                            final CharacterFloatMap.PrimitiveEntry o = (CharacterFloatMap.PrimitiveEntry)i.next();
                            return new CharacterMap.PrimitiveEntryK<Float>(){

                                @Override
                                public char getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Float putElement(char k, Float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(CharacterMap<Float> map) {
        for (CharacterMap.PrimitiveEntryK<Float> e : map.charKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<FloatValueMap.PrimitiveEntryV<Character>> floatValueEntrySet() {
        final Set<CharacterFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<FloatValueMap.PrimitiveEntryV<Character>>(){

                @Override
                public Iterator<FloatValueMap.PrimitiveEntryV<Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatValueMap.PrimitiveEntryV<Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatValueMap.PrimitiveEntryV<Character> next() {
                            final CharacterFloatMap.PrimitiveEntry o = (CharacterFloatMap.PrimitiveEntry)i.next();
                            return new FloatValueMap.PrimitiveEntryV<Character>(){

                                @Override
                                public Character getKey() {
                                    return Character.valueOf(o.getKey());
                                }

                                @Override
                                public float getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public float setValue(float value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public float getElement(Object k) {
        if (k instanceof Character) {
            return this.f(((Character)k).charValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public float putElement(Character k, float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatValueMap<Character> map) {
        for (FloatValueMap.PrimitiveEntryV<Character> e : map.floatValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection floatValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Float) {
            return this.containsValueElement(((Float)value).floatValue());
        }
        return false;
    }

    @Override
    public Float put(Character key, Float value) {
        return this.putElement(key.charValue(), value.floatValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (CharacterFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof CharacterFloatMap)) break block1;
            m = (CharacterFloatMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).floatValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (CharacterFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractCharacterSet {
        private Set<CharacterFloatMap.PrimitiveEntry> eset;

        private KSet(Set<CharacterFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public CharacterIterator charIterator() {
            final Iterator<CharacterFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new CharacterIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public char next() {
                    return ((CharacterFloatMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractCharacterFloatMap.this.size();
        }

        @Override
        public boolean containsChar(char o) {
            return AbstractCharacterFloatMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractCharacterFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractCharacterFloatMap.this.clear();
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractFloatCollection {
        private Set<CharacterFloatMap.PrimitiveEntry> eset;

        private VCol(Set<CharacterFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<CharacterFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public float next() {
                    return ((CharacterFloatMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractCharacterFloatMap.this.size();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractCharacterFloatMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractCharacterFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractCharacterFloatMap.this.clear();
        }
    }
}

