/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.AbstractShortCollection;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.ShortCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.map.op.ShortValueMap;
import net.morilib.util.primitive.map.po.ByteMap;
import net.morilib.util.primitive.map.pp.ByteShortMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteShortMap
implements ByteShortMap {
    private transient ByteSet keySet = null;
    private transient ShortCollection values = null;
    private transient Set<ByteMap.PrimitiveEntryK<Short>> entrySetK = null;
    private transient Set<ShortValueMap.PrimitiveEntryV<Byte>> entrySetV = null;
    private transient Set<Map.Entry<Byte, Short>> entrySet = null;

    @Override
    public void clear() {
        Iterator<ByteShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(short v) {
        for (ByteShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public short f(byte k) {
        for (ByteShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Short getElement(byte k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet byteKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ByteShortMap map) {
        for (ByteShortMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Short) {
            return this.containsKeyElement((Byte)key);
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        if (key instanceof Short) {
            return this.getElement((Byte)key);
        }
        return null;
    }

    @Override
    public Short put(Byte key, short value) {
        return this.putElement((byte)key, value);
    }

    @Override
    public Short remove(Object key) {
        if (key instanceof Short) {
            return this.removeElement((Byte)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Short> m) {
        for (Map.Entry<? extends Byte, ? extends Short> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteSet keySet() {
        return this.byteKeySet();
    }

    @Override
    public Set<Map.Entry<Byte, Short>> entrySet() {
        final Set<ByteShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Byte, Short>>(){

                @Override
                public Iterator<Map.Entry<Byte, Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Byte, Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Byte, Short> next() {
                            final ByteShortMap.PrimitiveEntry o = (ByteShortMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Byte, Short>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((byte)k);
    }

    @Override
    public boolean containsKeyElement(byte k) {
        for (ByteShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Short get(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((short)k);
    }

    @Override
    public Short put(int k, Short v) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((byte)k, v);
    }

    @Override
    public Short removeElement(byte k) {
        Iterator<ByteShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            ByteShortMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            short r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Short remove(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((byte)k);
    }

    @Override
    public Set<ByteMap.PrimitiveEntryK<Short>> byteKeyEntrySet() {
        final Set<ByteShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<ByteMap.PrimitiveEntryK<Short>>(){

                @Override
                public Iterator<ByteMap.PrimitiveEntryK<Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteMap.PrimitiveEntryK<Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteMap.PrimitiveEntryK<Short> next() {
                            final ByteShortMap.PrimitiveEntry o = (ByteShortMap.PrimitiveEntry)i.next();
                            return new ByteMap.PrimitiveEntryK<Short>(){

                                @Override
                                public byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Short putElement(byte k, Short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteMap<Short> map) {
        for (ByteMap.PrimitiveEntryK<Short> e : map.byteKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((short)v);
    }

    @Override
    public Set<ShortValueMap.PrimitiveEntryV<Byte>> shortValueEntrySet() {
        final Set<ByteShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ShortValueMap.PrimitiveEntryV<Byte>>(){

                @Override
                public Iterator<ShortValueMap.PrimitiveEntryV<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ShortValueMap.PrimitiveEntryV<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ShortValueMap.PrimitiveEntryV<Byte> next() {
                            final ByteShortMap.PrimitiveEntry o = (ByteShortMap.PrimitiveEntry)i.next();
                            return new ShortValueMap.PrimitiveEntryV<Byte>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public short setValue(short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public short getElement(Object k) {
        if (k instanceof Byte) {
            return this.f((Byte)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public short putElement(Byte k, short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ShortValueMap<Byte> map) {
        for (ShortValueMap.PrimitiveEntryV<Byte> e : map.shortValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection shortValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Short) {
            return this.containsValueElement((Short)value);
        }
        return false;
    }

    @Override
    public Short put(Byte key, Short value) {
        return this.putElement((byte)key, (short)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteShortMap)) break block1;
            m = (ByteShortMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractByteSet {
        private Set<ByteShortMap.PrimitiveEntry> eset;

        private KSet(Set<ByteShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<ByteShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((ByteShortMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteShortMap.this.size();
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractByteShortMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteShortMap.this.clear();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractShortCollection {
        private Set<ByteShortMap.PrimitiveEntry> eset;

        private VCol(Set<ByteShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ShortIterator shortIterator() {
            final Iterator<ByteShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ShortIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public short next() {
                    return ((ByteShortMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteShortMap.this.size();
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsShort(short o) {
            return AbstractByteShortMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteShortMap.this.clear();
        }
    }
}

