/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.AbstractLongCollection;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.LongCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.LongValueMap;
import net.morilib.util.primitive.map.po.ByteMap;
import net.morilib.util.primitive.map.pp.ByteLongMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteLongMap
implements ByteLongMap {
    private transient ByteSet keySet = null;
    private transient LongCollection values = null;
    private transient Set<ByteMap.PrimitiveEntryK<Long>> entrySetK = null;
    private transient Set<LongValueMap.PrimitiveEntryV<Byte>> entrySetV = null;
    private transient Set<Map.Entry<Byte, Long>> entrySet = null;

    @Override
    public void clear() {
        Iterator<ByteLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(long v) {
        for (ByteLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public long f(byte k) {
        for (ByteLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Long getElement(byte k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet byteKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ByteLongMap map) {
        for (ByteLongMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return this.containsKeyElement((Byte)key);
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        if (key instanceof Long) {
            return this.getElement((Byte)key);
        }
        return null;
    }

    @Override
    public Long put(Byte key, long value) {
        return this.putElement((byte)key, value);
    }

    @Override
    public Long remove(Object key) {
        if (key instanceof Long) {
            return this.removeElement((Byte)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Long> m) {
        for (Map.Entry<? extends Byte, ? extends Long> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteSet keySet() {
        return this.byteKeySet();
    }

    @Override
    public Set<Map.Entry<Byte, Long>> entrySet() {
        final Set<ByteLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Byte, Long>>(){

                @Override
                public Iterator<Map.Entry<Byte, Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Byte, Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Byte, Long> next() {
                            final ByteLongMap.PrimitiveEntry o = (ByteLongMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Byte, Long>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((byte)k);
    }

    @Override
    public boolean containsKeyElement(byte k) {
        for (ByteLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Long get(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Long put(int k, Long v) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((byte)k, v);
    }

    @Override
    public Long removeElement(byte k) {
        Iterator<ByteLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            ByteLongMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            long r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Long remove(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((byte)k);
    }

    @Override
    public Set<ByteMap.PrimitiveEntryK<Long>> byteKeyEntrySet() {
        final Set<ByteLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<ByteMap.PrimitiveEntryK<Long>>(){

                @Override
                public Iterator<ByteMap.PrimitiveEntryK<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteMap.PrimitiveEntryK<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteMap.PrimitiveEntryK<Long> next() {
                            final ByteLongMap.PrimitiveEntry o = (ByteLongMap.PrimitiveEntry)i.next();
                            return new ByteMap.PrimitiveEntryK<Long>(){

                                @Override
                                public byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Long putElement(byte k, Long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteMap<Long> map) {
        for (ByteMap.PrimitiveEntryK<Long> e : map.byteKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<LongValueMap.PrimitiveEntryV<Byte>> longValueEntrySet() {
        final Set<ByteLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<LongValueMap.PrimitiveEntryV<Byte>>(){

                @Override
                public Iterator<LongValueMap.PrimitiveEntryV<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongValueMap.PrimitiveEntryV<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongValueMap.PrimitiveEntryV<Byte> next() {
                            final ByteLongMap.PrimitiveEntry o = (ByteLongMap.PrimitiveEntry)i.next();
                            return new LongValueMap.PrimitiveEntryV<Byte>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public long setValue(long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public long getElement(Object k) {
        if (k instanceof Byte) {
            return this.f((Byte)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long putElement(Byte k, long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongValueMap<Byte> map) {
        for (LongValueMap.PrimitiveEntryV<Byte> e : map.longValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection longValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Long) {
            return this.containsValueElement((Long)value);
        }
        return false;
    }

    @Override
    public Long put(Byte key, Long value) {
        return this.putElement((byte)key, (long)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteLongMap)) break block1;
            m = (ByteLongMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractByteSet {
        private Set<ByteLongMap.PrimitiveEntry> eset;

        private KSet(Set<ByteLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<ByteLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((ByteLongMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteLongMap.this.size();
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractByteLongMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteLongMap.this.clear();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractLongCollection {
        private Set<ByteLongMap.PrimitiveEntry> eset;

        private VCol(Set<ByteLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<ByteLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public long next() {
                    return ((ByteLongMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteLongMap.this.size();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractByteLongMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteLongMap.this.clear();
        }
    }
}

