/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.AbstractIntegerCollection;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.IntegerValueMap;
import net.morilib.util.primitive.map.po.ByteMap;
import net.morilib.util.primitive.map.pp.ByteIntegerMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteIntegerMap
implements ByteIntegerMap {
    private transient ByteSet keySet = null;
    private transient IntegerCollection values = null;
    private transient Set<ByteMap.PrimitiveEntryK<Integer>> entrySetK = null;
    private transient Set<IntegerValueMap.PrimitiveEntryV<Byte>> entrySetV = null;
    private transient Set<Map.Entry<Byte, Integer>> entrySet = null;

    @Override
    public void clear() {
        Iterator<ByteIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(int v) {
        for (ByteIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public int f(byte k) {
        for (ByteIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Integer getElement(byte k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet byteKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ByteIntegerMap map) {
        for (ByteIntegerMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKeyElement((Byte)key);
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        if (key instanceof Integer) {
            return this.getElement((Byte)key);
        }
        return null;
    }

    @Override
    public Integer put(Byte key, int value) {
        return this.putElement((byte)key, value);
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof Integer) {
            return this.removeElement((Byte)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Integer> m) {
        for (Map.Entry<? extends Byte, ? extends Integer> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteSet keySet() {
        return this.byteKeySet();
    }

    @Override
    public Set<Map.Entry<Byte, Integer>> entrySet() {
        final Set<ByteIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Byte, Integer>>(){

                @Override
                public Iterator<Map.Entry<Byte, Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Byte, Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Byte, Integer> next() {
                            final ByteIntegerMap.PrimitiveEntry o = (ByteIntegerMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Byte, Integer>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((byte)k);
    }

    @Override
    public boolean containsKeyElement(byte k) {
        for (ByteIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer get(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Integer put(int k, Integer v) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((byte)k, v);
    }

    @Override
    public Integer removeElement(byte k) {
        Iterator<ByteIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            ByteIntegerMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            int r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Integer remove(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((byte)k);
    }

    @Override
    public Set<ByteMap.PrimitiveEntryK<Integer>> byteKeyEntrySet() {
        final Set<ByteIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<ByteMap.PrimitiveEntryK<Integer>>(){

                @Override
                public Iterator<ByteMap.PrimitiveEntryK<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteMap.PrimitiveEntryK<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteMap.PrimitiveEntryK<Integer> next() {
                            final ByteIntegerMap.PrimitiveEntry o = (ByteIntegerMap.PrimitiveEntry)i.next();
                            return new ByteMap.PrimitiveEntryK<Integer>(){

                                @Override
                                public byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Integer putElement(byte k, Integer v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteMap<Integer> map) {
        for (ByteMap.PrimitiveEntryK<Integer> e : map.byteKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<IntegerValueMap.PrimitiveEntryV<Byte>> intValueEntrySet() {
        final Set<ByteIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<IntegerValueMap.PrimitiveEntryV<Byte>>(){

                @Override
                public Iterator<IntegerValueMap.PrimitiveEntryV<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerValueMap.PrimitiveEntryV<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerValueMap.PrimitiveEntryV<Byte> next() {
                            final ByteIntegerMap.PrimitiveEntry o = (ByteIntegerMap.PrimitiveEntry)i.next();
                            return new IntegerValueMap.PrimitiveEntryV<Byte>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public int getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public int setValue(int value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public int getElement(Object k) {
        if (k instanceof Byte) {
            return this.f((Byte)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int putElement(Byte k, int v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerValueMap<Byte> map) {
        for (IntegerValueMap.PrimitiveEntryV<Byte> e : map.intValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection intValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            return this.containsValueElement((Integer)value);
        }
        return false;
    }

    @Override
    public Integer put(Byte key, Integer value) {
        return this.putElement((byte)key, (int)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteIntegerMap)) break block1;
            m = (ByteIntegerMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractByteSet {
        private Set<ByteIntegerMap.PrimitiveEntry> eset;

        private KSet(Set<ByteIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<ByteIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((ByteIntegerMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteIntegerMap.this.size();
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractByteIntegerMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteIntegerMap.this.clear();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractIntegerCollection {
        private Set<ByteIntegerMap.PrimitiveEntry> eset;

        private VCol(Set<ByteIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<ByteIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public int next() {
                    return ((ByteIntegerMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteIntegerMap.this.size();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractByteIntegerMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteIntegerMap.this.clear();
        }
    }
}

