/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.AbstractFloatCollection;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.FloatCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.op.FloatValueMap;
import net.morilib.util.primitive.map.po.ByteMap;
import net.morilib.util.primitive.map.pp.ByteFloatMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteFloatMap
implements ByteFloatMap {
    private transient ByteSet keySet = null;
    private transient FloatCollection values = null;
    private transient Set<ByteMap.PrimitiveEntryK<Float>> entrySetK = null;
    private transient Set<FloatValueMap.PrimitiveEntryV<Byte>> entrySetV = null;
    private transient Set<Map.Entry<Byte, Float>> entrySet = null;

    @Override
    public void clear() {
        Iterator<ByteFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(float v) {
        for (ByteFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public float f(byte k) {
        for (ByteFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Float getElement(byte k) {
        return Float.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet byteKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ByteFloatMap map) {
        for (ByteFloatMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Float) {
            return this.containsKeyElement((Byte)key);
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        if (key instanceof Float) {
            return this.getElement((Byte)key);
        }
        return null;
    }

    @Override
    public Float put(Byte key, float value) {
        return this.putElement((byte)key, value);
    }

    @Override
    public Float remove(Object key) {
        if (key instanceof Float) {
            return this.removeElement((Byte)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Float> m) {
        for (Map.Entry<? extends Byte, ? extends Float> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteSet keySet() {
        return this.byteKeySet();
    }

    @Override
    public Set<Map.Entry<Byte, Float>> entrySet() {
        final Set<ByteFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Byte, Float>>(){

                @Override
                public Iterator<Map.Entry<Byte, Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Byte, Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Byte, Float> next() {
                            final ByteFloatMap.PrimitiveEntry o = (ByteFloatMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Byte, Float>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((byte)k);
    }

    @Override
    public boolean containsKeyElement(byte k) {
        for (ByteFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float get(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return Float.valueOf(this.getElement(Float.valueOf(k)));
    }

    @Override
    public Float put(int k, Float v) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((byte)k, v);
    }

    @Override
    public Float removeElement(byte k) {
        Iterator<ByteFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            ByteFloatMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            float r = e.getValue();
            i.remove();
            return Float.valueOf(r);
        }
        return null;
    }

    @Override
    public Float remove(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((byte)k);
    }

    @Override
    public Set<ByteMap.PrimitiveEntryK<Float>> byteKeyEntrySet() {
        final Set<ByteFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<ByteMap.PrimitiveEntryK<Float>>(){

                @Override
                public Iterator<ByteMap.PrimitiveEntryK<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteMap.PrimitiveEntryK<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteMap.PrimitiveEntryK<Float> next() {
                            final ByteFloatMap.PrimitiveEntry o = (ByteFloatMap.PrimitiveEntry)i.next();
                            return new ByteMap.PrimitiveEntryK<Float>(){

                                @Override
                                public byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Float putElement(byte k, Float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteMap<Float> map) {
        for (ByteMap.PrimitiveEntryK<Float> e : map.byteKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<FloatValueMap.PrimitiveEntryV<Byte>> floatValueEntrySet() {
        final Set<ByteFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<FloatValueMap.PrimitiveEntryV<Byte>>(){

                @Override
                public Iterator<FloatValueMap.PrimitiveEntryV<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatValueMap.PrimitiveEntryV<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatValueMap.PrimitiveEntryV<Byte> next() {
                            final ByteFloatMap.PrimitiveEntry o = (ByteFloatMap.PrimitiveEntry)i.next();
                            return new FloatValueMap.PrimitiveEntryV<Byte>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public float getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public float setValue(float value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public float getElement(Object k) {
        if (k instanceof Byte) {
            return this.f((Byte)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public float putElement(Byte k, float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatValueMap<Byte> map) {
        for (FloatValueMap.PrimitiveEntryV<Byte> e : map.floatValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection floatValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Float) {
            return this.containsValueElement(((Float)value).floatValue());
        }
        return false;
    }

    @Override
    public Float put(Byte key, Float value) {
        return this.putElement((byte)key, value.floatValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteFloatMap)) break block1;
            m = (ByteFloatMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).floatValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractByteSet {
        private Set<ByteFloatMap.PrimitiveEntry> eset;

        private KSet(Set<ByteFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<ByteFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((ByteFloatMap.PrimitiveEntry)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteFloatMap.this.size();
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractByteFloatMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteFloatMap.this.clear();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractFloatCollection {
        private Set<ByteFloatMap.PrimitiveEntry> eset;

        private VCol(Set<ByteFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<ByteFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public float next() {
                    return ((ByteFloatMap.PrimitiveEntry)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteFloatMap.this.size();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractByteFloatMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteFloatMap.this.clear();
        }
    }
}

