/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.map.po.AbstractDoubleMap;
import net.morilib.util.primitive.map.po.DoubleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleHashMap<V>
extends AbstractDoubleMap<V>
implements Serializable {
    private static final long serialVersionUID = 4823620077843167065L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object MARK_A = new Object();
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<DoubleMap.PrimitiveEntryK<V>> entrySet;

    /*
     * Unable to fully structure code
     */
    public DoubleHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl13
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl13:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public DoubleHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public DoubleHashMap() {
        this(16, 0.75f);
    }

    public DoubleHashMap(DoubleMap<V> mp) {
        this(16, 0.75f);
        this.putAllElement(mp);
    }

    private Iterator<DoubleMap.PrimitiveEntryK<V>> doubleEntrySetIterator() {
        return new Iterator<DoubleMap.PrimitiveEntryK<V>>(){
            private int ptr = -1;
            private Ent e = this._next();
            private Ent remove = null;
            private int exModCount;
            {
                this.exModCount = DoubleHashMap.this.modCount;
            }

            /*
             * Unable to fully structure code
             */
            private Ent _next() {
                v0 = this.e = this.ptr < 0 ? null : Ent.access$0(this.e);
                if (this.e == null) ** GOTO lbl6
                return this.e;
lbl-1000:
                // 1 sources

                {
                    if (DoubleHashMap.access$2(DoubleHashMap.this)[this.ptr] == null) continue;
                    return DoubleHashMap.access$2(DoubleHashMap.this)[this.ptr];
lbl6:
                    // 2 sources

                    ** while (++this.ptr < DoubleHashMap.access$2((DoubleHashMap)DoubleHashMap.this).length)
                }
lbl7:
                // 1 sources

                return null;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public DoubleMap.PrimitiveEntryK<V> next() {
                this.remove = this.e;
                if (this.e == null) {
                    throw new NoSuchElementException();
                }
                if (this.exModCount != DoubleHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.e = this._next();
                return this.remove;
            }

            @Override
            public void remove() {
                if (this.remove == null) {
                    throw new IllegalStateException();
                }
                DoubleHashMap.this._remove(this.remove.key);
                this.exModCount = DoubleHashMap.this.modCount;
                this.remove = null;
            }
        };
    }

    @Override
    public Set<DoubleMap.PrimitiveEntryK<V>> doubleKeyEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<DoubleMap.PrimitiveEntryK<V>>(){

                @Override
                public Iterator<DoubleMap.PrimitiveEntryK<V>> iterator() {
                    return DoubleHashMap.this.doubleEntrySetIterator();
                }

                @Override
                public int size() {
                    return DoubleHashMap.this.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(double k) {
        return (int)Double.doubleToLongBits(k);
    }

    private Ent _get(double k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public V getElement(double k) {
        return (V)this._get(k).value;
    }

    @Override
    public boolean containsKeyElement(double k) {
        return this._get(k) != null;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (DoubleMap.PrimitiveEntryK<V> e : this.doubleKeyEntrySet()) {
                double b = e.getKey();
                int h = this.getHash(b) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(b, e.getValue());
                    continue;
                }
                ne[h].putEntry(b, e.getValue());
            }
        }
    }

    @Override
    public V putElement(double k, V v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return null;
        }
        Object r = this.ent[h].putEntry(k, v);
        if (r == MARK_A) {
            ++this.size;
            this.resize();
            return null;
        }
        return (V)r;
    }

    private boolean _putEntry(double k, V v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v);
            return true;
        }
        return this.ent[h].putEntry(k, v) != MARK_A;
    }

    private Ent _remove(double k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == this.ent[h].key) {
            Ent r = this.ent[h];
            --this.size;
            this.ent[h] = r.next;
            return r;
        }
        --this.size;
        return this.ent[h].removeEntry(k);
    }

    @Override
    public V removeElement(double k) {
        Ent r = this._remove(k);
        return (V)(r != null ? r.value : null);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (DoubleMap.PrimitiveEntryK<V> e : this.doubleKeyEntrySet()) {
            s.writeDouble(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            double k = s.readDouble();
            Object v = s.readObject();
            this._putEntry(k, v);
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$2(DoubleHashMap doubleHashMap) {
        return doubleHashMap.ent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ent<V>
    implements DoubleMap.PrimitiveEntryK<V> {
        private double key;
        private V value;
        private Ent<V> next;

        private Ent(double key, V value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return (int)this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == e.key;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(Double.toString(this.key)) + "=" + this.value;
        }

        private Ent searchEntry(double k) {
            Ent<V> f = this;
            while (f != null) {
                if (k == f.key) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent removeEntry(double k) {
            Ent<V> g = this;
            Ent<V> f = this.next;
            while (f != null) {
                if (k == f.key) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Object putEntry(double k, V v) {
            Ent<V> g = this;
            Ent<V> f = this.next;
            while (f != null) {
                if (k == f.key) {
                    V r = f.value;
                    f.value = v;
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent<V>(k, v);
            return MARK_A;
        }

        @Override
        public double getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V r = this.value;
            this.value = v;
            return r;
        }
    }
}

