/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.primitive.AbstractShortSet;
import net.morilib.util.primitive.ShortSet;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.map.po.ShortMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShortMap<V>
implements ShortMap<V> {
    private static final long serialVersionUID = 4823620077843167065L;
    private transient ShortSet keySet = null;
    private transient Collection<V> values = null;

    @Override
    public void clear() {
        Iterator i = this.shortKeyEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValue(Object v) {
        for (ShortMap.PrimitiveEntryK e : this.shortKeyEntrySet()) {
            Object p = e.getValue();
            if ((v != null || p != null) && (v == null || !v.equals(p))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getElement(short k) {
        for (ShortMap.PrimitiveEntryK e : this.shortKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet shortKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.shortKeyEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ShortMap<V> map) {
        for (ShortMap.PrimitiveEntryK<V> e : map.shortKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new VCol(this.shortKeyEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Short) {
            return this.containsKeyElement((Short)key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof Short) {
            return this.getElement((Short)key);
        }
        return null;
    }

    @Override
    public V put(Short key, V value) {
        return this.putElement(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Short) {
            return this.removeElement((Short)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Short, ? extends V> m) {
        for (Map.Entry<Short, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Short> keySet() {
        return this.shortKeySet();
    }

    @Override
    public Set<Map.Entry<Short, V>> entrySet() {
        final Set e = this.shortKeyEntrySet();
        return new AbstractSet<Map.Entry<Short, V>>(){

            @Override
            public Iterator<Map.Entry<Short, V>> iterator() {
                final Iterator i = e.iterator();
                return new Iterator<Map.Entry<Short, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<Short, V> next() {
                        final ShortMap.PrimitiveEntryK o = (ShortMap.PrimitiveEntryK)i.next();
                        return new Map.Entry<Short, V>(){

                            @Override
                            public Short getKey() {
                                return o.getKey();
                            }

                            @Override
                            public V getValue() {
                                return o.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return o.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public boolean containsKey(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((short)k);
    }

    @Override
    public boolean containsKeyElement(short k) {
        for (ShortMap.PrimitiveEntryK e : this.shortKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((short)k);
    }

    @Override
    public V put(int k, V v) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((short)k, v);
    }

    @Override
    public V removeElement(short k) {
        Iterator i = this.shortKeyEntrySet().iterator();
        while (i.hasNext()) {
            ShortMap.PrimitiveEntryK e = i.next();
            if (e.getKey() != k) continue;
            Object r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public V remove(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((short)k);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ShortMap.PrimitiveEntryK e : this.shortKeyEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ShortMap)) break block1;
            m = (ShortMap)obj;
            i = this.shortKeyEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && (v == null && p == null || v != null && v.equals(p))) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ShortMap.PrimitiveEntryK e : this.shortKeyEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractShortSet {
        private Set<ShortMap.PrimitiveEntryK<V>> eset;

        private KSet(Set<ShortMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public ShortIterator shortIterator() {
            final Iterator ei = this.eset.iterator();
            return new ShortIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public short next() {
                    return ((ShortMap.PrimitiveEntryK)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractShortMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractShortMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractShortMap.this.clear();
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractCollection<V> {
        private Set<ShortMap.PrimitiveEntryK<V>> eset;

        private VCol(Set<ShortMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public V next() {
                    return ((ShortMap.PrimitiveEntryK)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractShortMap.this.size();
        }
    }
}

