/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.primitive.AbstractFloatSet;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.po.FloatMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatMap<V>
implements FloatMap<V> {
    private static final long serialVersionUID = 4823620077843167065L;
    private transient FloatSet keySet = null;
    private transient Collection<V> values = null;

    @Override
    public void clear() {
        Iterator i = this.floatKeyEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValue(Object v) {
        for (FloatMap.PrimitiveEntryK e : this.floatKeyEntrySet()) {
            Object p = e.getValue();
            if ((v != null || p != null) && (v == null || !v.equals(p))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getElement(float k) {
        for (FloatMap.PrimitiveEntryK e : this.floatKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet floatKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.floatKeyEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(FloatMap<V> map) {
        for (FloatMap.PrimitiveEntryK<V> e : map.floatKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new VCol(this.floatKeyEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Float) {
            return this.containsKeyElement(((Float)key).floatValue());
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof Float) {
            return this.getElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public V put(Float key, V value) {
        return this.putElement(key.floatValue(), value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Float) {
            return this.removeElement(((Float)key).floatValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends V> m) {
        for (Map.Entry<Float, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Float> keySet() {
        return this.floatKeySet();
    }

    @Override
    public Set<Map.Entry<Float, V>> entrySet() {
        final Set e = this.floatKeyEntrySet();
        return new AbstractSet<Map.Entry<Float, V>>(){

            @Override
            public Iterator<Map.Entry<Float, V>> iterator() {
                final Iterator i = e.iterator();
                return new Iterator<Map.Entry<Float, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<Float, V> next() {
                        final FloatMap.PrimitiveEntryK o = (FloatMap.PrimitiveEntryK)i.next();
                        return new Map.Entry<Float, V>(){

                            @Override
                            public Float getKey() {
                                return Float.valueOf(o.getKey());
                            }

                            @Override
                            public V getValue() {
                                return o.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return o.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public boolean containsKey(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(float k) {
        for (FloatMap.PrimitiveEntryK e : this.floatKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public V put(int k, V v) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public V removeElement(float k) {
        Iterator i = this.floatKeyEntrySet().iterator();
        while (i.hasNext()) {
            FloatMap.PrimitiveEntryK e = i.next();
            if (e.getKey() != k) continue;
            Object r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public V remove(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatMap.PrimitiveEntryK e : this.floatKeyEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatMap)) break block1;
            m = (FloatMap)obj;
            i = this.floatKeyEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && (v == null && p == null || v != null && v.equals(p))) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatMap.PrimitiveEntryK e : this.floatKeyEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractFloatSet {
        private Set<FloatMap.PrimitiveEntryK<V>> eset;

        private KSet(Set<FloatMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator ei = this.eset.iterator();
            return new FloatIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public float next() {
                    return ((FloatMap.PrimitiveEntryK)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractFloatMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatMap.this.clear();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractCollection<V> {
        private Set<FloatMap.PrimitiveEntryK<V>> eset;

        private VCol(Set<FloatMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public V next() {
                    return ((FloatMap.PrimitiveEntryK)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatMap.this.size();
        }
    }
}

