/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleSet;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.map.po.DoubleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleMap<V>
implements DoubleMap<V> {
    private static final long serialVersionUID = 4823620077843167065L;
    private transient DoubleSet keySet = null;
    private transient Collection<V> values = null;

    @Override
    public void clear() {
        Iterator i = this.doubleKeyEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValue(Object v) {
        for (DoubleMap.PrimitiveEntryK e : this.doubleKeyEntrySet()) {
            Object p = e.getValue();
            if ((v != null || p != null) && (v == null || !v.equals(p))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getElement(double k) {
        for (DoubleMap.PrimitiveEntryK e : this.doubleKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet doubleKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.doubleKeyEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(DoubleMap<V> map) {
        for (DoubleMap.PrimitiveEntryK<V> e : map.doubleKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new VCol(this.doubleKeyEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Double) {
            return this.containsKeyElement((Double)key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof Double) {
            return this.getElement((Double)key);
        }
        return null;
    }

    @Override
    public V put(Double key, V value) {
        return this.putElement(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Double) {
            return this.removeElement((Double)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends V> m) {
        for (Map.Entry<Double, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Double> keySet() {
        return this.doubleKeySet();
    }

    @Override
    public Set<Map.Entry<Double, V>> entrySet() {
        final Set e = this.doubleKeyEntrySet();
        return new AbstractSet<Map.Entry<Double, V>>(){

            @Override
            public Iterator<Map.Entry<Double, V>> iterator() {
                final Iterator i = e.iterator();
                return new Iterator<Map.Entry<Double, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<Double, V> next() {
                        final DoubleMap.PrimitiveEntryK o = (DoubleMap.PrimitiveEntryK)i.next();
                        return new Map.Entry<Double, V>(){

                            @Override
                            public Double getKey() {
                                return o.getKey();
                            }

                            @Override
                            public V getValue() {
                                return o.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return o.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public boolean containsKey(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(double k) {
        for (DoubleMap.PrimitiveEntryK e : this.doubleKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public V put(int k, V v) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public V removeElement(double k) {
        Iterator i = this.doubleKeyEntrySet().iterator();
        while (i.hasNext()) {
            DoubleMap.PrimitiveEntryK e = i.next();
            if (e.getKey() != k) continue;
            Object r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public V remove(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (DoubleMap.PrimitiveEntryK e : this.doubleKeyEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof DoubleMap)) break block1;
            m = (DoubleMap)obj;
            i = this.doubleKeyEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && (v == null && p == null || v != null && v.equals(p))) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (DoubleMap.PrimitiveEntryK e : this.doubleKeyEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractDoubleSet {
        private Set<DoubleMap.PrimitiveEntryK<V>> eset;

        private KSet(Set<DoubleMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((DoubleMap.PrimitiveEntryK)ei.next()).getKey();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractDoubleMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleMap.this.clear();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractCollection<V> {
        private Set<DoubleMap.PrimitiveEntryK<V>> eset;

        private VCol(Set<DoubleMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public V next() {
                    return ((DoubleMap.PrimitiveEntryK)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleMap.this.size();
        }
    }
}

