/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.op;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractIntegerCollection;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.AbstractIntegerValueMap;
import net.morilib.util.primitive.map.op.IntegerValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityIntegerValueHashMap<K>
extends AbstractIntegerValueMap<K>
implements Serializable {
    private static final long serialVersionUID = 4823620077843167065L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<IntegerValueMap.PrimitiveEntryV<K>> entrySet;
    private transient Set<K> keySet;
    private transient IntegerCollection values;

    /*
     * Unable to fully structure code
     */
    public IdentityIntegerValueHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            this.keySet = null;
            this.values = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl15
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl15:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public IdentityIntegerValueHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityIntegerValueHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public IdentityIntegerValueHashMap() {
        this(16, 0.75f);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(Object k) {
        return k == null ? 0 : System.identityHashCode(k);
    }

    private Ent<?> _get(Object k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsKey(Object k) {
        return this._get(k) != null;
    }

    @Override
    public Set<IntegerValueMap.PrimitiveEntryV<K>> intValueEntrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new ESet());
    }

    @Override
    public Integer get(Object k) {
        Ent<?> e = this._get(k);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return ((Ent)e).value;
    }

    @Override
    public int getElement(Object k) {
        Ent<?> e = this._get(k);
        return e == null ? null : Integer.valueOf(((Ent)e).value);
    }

    @Override
    public Set<K> keySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.intValueEntrySet())) : this.keySet;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (IntegerValueMap.PrimitiveEntryV<K> e : this.intValueEntrySet()) {
                int h = this.getHash(e.getKey()) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(e.getKey(), e.getValue());
                    continue;
                }
                ne[h].putEntry(e.getKey(), e.getValue());
            }
        }
    }

    private void _putEntry(K k, int v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v);
        } else {
            this.ent[h].putEntry(k, v);
        }
    }

    @Override
    public int putElement(K k, int v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return 0;
        }
        Integer r = this.ent[h].putEntry(k, v);
        if (r == null) {
            ++this.size;
            this.resize();
        }
        return r;
    }

    @Override
    public void putAllElement(IntegerValueMap<K> map) {
        int nd = map.size();
        ++this.modCount;
        if (nd == 0) {
            return;
        }
        this.size += nd;
        this.resize();
        for (IntegerValueMap.PrimitiveEntryV<K> e : this.intValueEntrySet()) {
            int h = this.getHash(e.getKey()) % this.ent.length;
            if (this.ent[h] == null) {
                this.ent[h] = new Ent(e.getKey(), e.getValue());
                continue;
            }
            this.ent[h].putEntry(e.getKey(), e.getValue());
        }
    }

    Ent<?> _remove(Object k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == null && this.ent[h].key == null || k != null && k == this.ent[h].key) {
            Ent r = this.ent[h];
            this.ent[h] = r.next;
            return r;
        }
        return this.ent[h].removeEntry(k);
    }

    @Override
    public Integer remove(Object k) {
        Ent<?> e = this._remove(k);
        return e == null ? null : Integer.valueOf(((Ent)e).value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IntegerCollection intValues() {
        return this.values == null ? (this.values = new VCol(this.intValueEntrySet())) : this.values;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (IntegerValueMap.PrimitiveEntryV<K> e : this.intValueEntrySet()) {
            s.writeObject(e.getKey());
            s.writeInt(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            this._putEntry(s.readObject(), s.readInt());
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$1(IdentityIntegerValueHashMap identityIntegerValueHashMap) {
        return identityIntegerValueHashMap.ent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ESet
    extends AbstractSet<IntegerValueMap.PrimitiveEntryV<K>> {
        private ESet() {
        }

        @Override
        public Iterator<IntegerValueMap.PrimitiveEntryV<K>> iterator() {
            return new Iterator<IntegerValueMap.PrimitiveEntryV<K>>(){
                private int ptr = 0;
                private Ent<?> e = this._next();
                private Ent<?> remove = null;
                private int exModCount;
                {
                    this.exModCount = IdentityIntegerValueHashMap.this.modCount;
                }

                /*
                 * Unable to fully structure code
                 */
                private Ent<?> _next() {
                    if (Ent.access$0(this.e) == null) ** GOTO lbl5
                    return Ent.access$0(this.e);
lbl-1000:
                    // 1 sources

                    {
                        if (IdentityIntegerValueHashMap.access$1(ESet.access$1(ESet.this))[this.ptr] == null) continue;
                        return IdentityIntegerValueHashMap.access$1(ESet.access$1(ESet.this))[this.ptr];
lbl5:
                        // 2 sources

                        ** while (++this.ptr < IdentityIntegerValueHashMap.access$1((IdentityIntegerValueHashMap)ESet.access$1((ESet)ESet.this)).length)
                    }
lbl6:
                    // 1 sources

                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.e != null;
                }

                @Override
                public IntegerValueMap.PrimitiveEntryV<K> next() {
                    this.remove = this.e;
                    if (this.e == null) {
                        throw new NoSuchElementException();
                    }
                    if (this.exModCount != IdentityIntegerValueHashMap.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    this.e = this._next();
                    return this.remove;
                }

                @Override
                public void remove() {
                    if (this.remove == null) {
                        throw new IllegalStateException();
                    }
                    IdentityIntegerValueHashMap.this.remove(((Ent)this.e).key);
                    this.exModCount = IdentityIntegerValueHashMap.this.modCount;
                    this.remove = null;
                }
            };
        }

        @Override
        public int size() {
            return IdentityIntegerValueHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Ent) {
                return IdentityIntegerValueHashMap.this.containsKey(((Ent)o).key);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Ent) {
                return IdentityIntegerValueHashMap.this._remove(((Ent)o).getKey()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            IdentityIntegerValueHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ent<K>
    implements IntegerValueMap.PrimitiveEntryV<K> {
        private K key;
        private int value;
        private Ent<?> next;

        private Ent(K key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public int setValue(int v) {
            int r = this.value;
            this.value = v;
            return r;
        }

        public int hashCode() {
            return (this.key == null ? 0 : System.identityHashCode(this.key)) ^ this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == null && e.key == null || this.key != null && this.key == e.key && this.value == e.value;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private Ent<?> searchEntry(Object k) {
            Ent<?> f = this;
            while (f != null) {
                if (f.key == null && k == null || k != null && k == f.key) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent<?> removeEntry(Object k) {
            Ent<?> g = this;
            Ent<?> f = this.next;
            while (f != null) {
                if (f.key == null && k == null || k != null && k == f.key) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Integer putEntry(K k, int v) {
            Ent<?> g = this;
            Ent<?> f = this.next;
            while (f != null) {
                if (f.key == null && k == null || k != null && k == f.key) {
                    Integer r = new Integer(f.value);
                    f.value = v;
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent<K>(k, v);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractSet<K> {
        private Set<IntegerValueMap.PrimitiveEntryV<K>> eset;

        private KSet(Set<IntegerValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public K next() {
                    return ((IntegerValueMap.PrimitiveEntryV)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return IdentityIntegerValueHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IdentityIntegerValueHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return IdentityIntegerValueHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            IdentityIntegerValueHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractIntegerCollection {
        private Set<IntegerValueMap.PrimitiveEntryV<K>> eset;

        private VCol(Set<IntegerValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator ei = this.eset.iterator();
            return new IntegerIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public int next() {
                    return ((IntegerValueMap.PrimitiveEntryV)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return IdentityIntegerValueHashMap.this.size;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }
    }
}

