/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.op;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.map.op.AbstractDoubleValueMap;
import net.morilib.util.primitive.map.op.DoubleValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleValueHashMap<K>
extends AbstractDoubleValueMap<K>
implements Serializable {
    private static final long serialVersionUID = 4823620077843167065L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<DoubleValueMap.PrimitiveEntryV<K>> entrySet;
    private transient Set<K> keySet;
    private transient DoubleCollection values;

    /*
     * Unable to fully structure code
     */
    public DoubleValueHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            this.keySet = null;
            this.values = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl15
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl15:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public DoubleValueHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleValueHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public DoubleValueHashMap() {
        this(16, 0.75f);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(Object k) {
        return k == null ? 0 : k.hashCode();
    }

    private Ent<?> _get(Object k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsKey(Object k) {
        return this._get(k) != null;
    }

    @Override
    public Set<DoubleValueMap.PrimitiveEntryV<K>> doubleValueEntrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new ESet());
    }

    @Override
    public Double get(Object k) {
        Ent<?> e = this._get(k);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return ((Ent)e).value;
    }

    @Override
    public double getElement(Object k) {
        Ent<?> e = this._get(k);
        return e == null ? null : Double.valueOf(((Ent)e).value);
    }

    @Override
    public Set<K> keySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.doubleValueEntrySet())) : this.keySet;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (DoubleValueMap.PrimitiveEntryV<K> e : this.doubleValueEntrySet()) {
                int h = this.getHash(e.getKey()) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(e.getKey(), e.getValue());
                    continue;
                }
                ne[h].putEntry(e.getKey(), e.getValue());
            }
        }
    }

    private void _putEntry(K k, double v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v);
        } else {
            this.ent[h].putEntry(k, v);
        }
    }

    @Override
    public double putElement(K k, double v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return 0.0;
        }
        Double r = this.ent[h].putEntry(k, v);
        if (r == null) {
            ++this.size;
            this.resize();
        }
        return r;
    }

    @Override
    public void putAllElement(DoubleValueMap<K> map) {
        int nd = map.size();
        ++this.modCount;
        if (nd == 0) {
            return;
        }
        this.size += nd;
        this.resize();
        for (DoubleValueMap.PrimitiveEntryV<K> e : this.doubleValueEntrySet()) {
            int h = this.getHash(e.getKey()) % this.ent.length;
            if (this.ent[h] == null) {
                this.ent[h] = new Ent(e.getKey(), e.getValue());
                continue;
            }
            this.ent[h].putEntry(e.getKey(), e.getValue());
        }
    }

    private Ent<?> _remove(Object k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == null && this.ent[h].key == null || k != null && k.equals(this.ent[h].key)) {
            Ent r = this.ent[h];
            this.ent[h] = r.next;
            return r;
        }
        return this.ent[h].removeEntry(k);
    }

    @Override
    public Double remove(Object k) {
        Ent<?> e = this._remove(k);
        return e == null ? null : Double.valueOf(((Ent)e).value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public DoubleCollection doubleValues() {
        return this.values == null ? (this.values = new VCol(this.doubleValueEntrySet())) : this.values;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (DoubleValueMap.PrimitiveEntryV<K> e : this.doubleValueEntrySet()) {
            s.writeObject(e.getKey());
            s.writeDouble(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            this._putEntry(s.readObject(), s.readDouble());
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$1(DoubleValueHashMap doubleValueHashMap) {
        return doubleValueHashMap.ent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ESet
    extends AbstractSet<DoubleValueMap.PrimitiveEntryV<K>> {
        private ESet() {
        }

        @Override
        public Iterator<DoubleValueMap.PrimitiveEntryV<K>> iterator() {
            return new Iterator<DoubleValueMap.PrimitiveEntryV<K>>(){
                private int ptr = 0;
                private Ent<?> e = this._next();
                private Ent<?> remove = null;
                private int exModCount;
                {
                    this.exModCount = DoubleValueHashMap.this.modCount;
                }

                /*
                 * Unable to fully structure code
                 */
                private Ent<?> _next() {
                    if (Ent.access$0(this.e) == null) ** GOTO lbl5
                    return Ent.access$0(this.e);
lbl-1000:
                    // 1 sources

                    {
                        if (DoubleValueHashMap.access$1(ESet.access$1(ESet.this))[this.ptr] == null) continue;
                        return DoubleValueHashMap.access$1(ESet.access$1(ESet.this))[this.ptr];
lbl5:
                        // 2 sources

                        ** while (++this.ptr < DoubleValueHashMap.access$1((DoubleValueHashMap)ESet.access$1((ESet)ESet.this)).length)
                    }
lbl6:
                    // 1 sources

                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.e != null;
                }

                @Override
                public DoubleValueMap.PrimitiveEntryV<K> next() {
                    this.remove = this.e;
                    if (this.e == null) {
                        throw new NoSuchElementException();
                    }
                    if (this.exModCount != DoubleValueHashMap.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    this.e = this._next();
                    return this.remove;
                }

                @Override
                public void remove() {
                    if (this.remove == null) {
                        throw new IllegalStateException();
                    }
                    DoubleValueHashMap.this.remove(((Ent)this.e).key);
                    this.exModCount = DoubleValueHashMap.this.modCount;
                    this.remove = null;
                }
            };
        }

        @Override
        public int size() {
            return DoubleValueHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Ent) {
                return DoubleValueHashMap.this.containsKey(((Ent)o).key);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Ent) {
                return DoubleValueHashMap.this._remove(((Ent)o).getKey()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            DoubleValueHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ent<K>
    implements DoubleValueMap.PrimitiveEntryV<K> {
        private K key;
        private double value;
        private Ent<?> next;

        private Ent(K key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public double setValue(double v) {
            double r = this.value;
            this.value = v;
            return r;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (int)this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == null && e.key == null || this.key != null && this.key.equals(e.key) && this.value == e.value;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private Ent<?> searchEntry(Object k) {
            Ent<?> f = this;
            while (f != null) {
                if (f.key == null && k == null || k != null && k.equals(f.key)) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent<?> removeEntry(Object k) {
            Ent<?> g = this;
            Ent<?> f = this.next;
            while (f != null) {
                if (f.key == null && k == null || k != null && k.equals(f.key)) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Double putEntry(K k, double v) {
            Ent<?> g = this;
            Ent<?> f = this.next;
            while (f != null) {
                if (f.key == null && k == null || k != null && k.equals(f.key)) {
                    Double r = new Double(f.value);
                    f.value = v;
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent<K>(k, v);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractSet<K> {
        private Set<DoubleValueMap.PrimitiveEntryV<K>> eset;

        private KSet(Set<DoubleValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public K next() {
                    return ((DoubleValueMap.PrimitiveEntryV)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return DoubleValueHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return DoubleValueHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return DoubleValueHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            DoubleValueHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractDoubleCollection {
        private Set<DoubleValueMap.PrimitiveEntryV<K>> eset;

        private VCol(Set<DoubleValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator ei = this.eset.iterator();
            return new DoubleIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public double next() {
                    return ((DoubleValueMap.PrimitiveEntryV)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return DoubleValueHashMap.this.size;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }
    }
}

