/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.op;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.map.op.AbstractByteValueMap;
import net.morilib.util.primitive.map.op.ByteValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteValueHashMap<K>
extends AbstractByteValueMap<K>
implements Serializable {
    private static final long serialVersionUID = 4823620077843167065L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<ByteValueMap.PrimitiveEntryV<K>> entrySet;
    private transient Set<K> keySet;
    private transient ByteCollection values;

    /*
     * Unable to fully structure code
     */
    public ByteValueHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            this.keySet = null;
            this.values = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl15
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl15:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public ByteValueHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteValueHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public ByteValueHashMap() {
        this(16, 0.75f);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(Object k) {
        return k == null ? 0 : k.hashCode();
    }

    private Ent<?> _get(Object k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsKey(Object k) {
        return this._get(k) != null;
    }

    @Override
    public Set<ByteValueMap.PrimitiveEntryV<K>> byteValueEntrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new ESet());
    }

    @Override
    public Byte get(Object k) {
        Ent<?> e = this._get(k);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return ((Ent)e).value;
    }

    @Override
    public byte getElement(Object k) {
        Ent<?> e = this._get(k);
        return e == null ? null : Byte.valueOf(((Ent)e).value);
    }

    @Override
    public Set<K> keySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.byteValueEntrySet())) : this.keySet;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (ByteValueMap.PrimitiveEntryV<K> e : this.byteValueEntrySet()) {
                int h = this.getHash(e.getKey()) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(e.getKey(), e.getValue());
                    continue;
                }
                ne[h].putEntry(e.getKey(), e.getValue());
            }
        }
    }

    private void _putEntry(K k, byte v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v);
        } else {
            this.ent[h].putEntry(k, v);
        }
    }

    @Override
    public byte putElement(K k, byte v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return 0;
        }
        Byte r = this.ent[h].putEntry(k, v);
        if (r == null) {
            ++this.size;
            this.resize();
        }
        return r;
    }

    @Override
    public void putAllElement(ByteValueMap<K> map) {
        int nd = map.size();
        ++this.modCount;
        if (nd == 0) {
            return;
        }
        this.size += nd;
        this.resize();
        for (ByteValueMap.PrimitiveEntryV<K> e : this.byteValueEntrySet()) {
            int h = this.getHash(e.getKey()) % this.ent.length;
            if (this.ent[h] == null) {
                this.ent[h] = new Ent(e.getKey(), e.getValue());
                continue;
            }
            this.ent[h].putEntry(e.getKey(), e.getValue());
        }
    }

    private Ent<?> _remove(Object k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == null && this.ent[h].key == null || k != null && k.equals(this.ent[h].key)) {
            Ent r = this.ent[h];
            this.ent[h] = r.next;
            return r;
        }
        return this.ent[h].removeEntry(k);
    }

    @Override
    public Byte remove(Object k) {
        Ent<?> e = this._remove(k);
        return e == null ? null : Byte.valueOf(((Ent)e).value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ByteCollection byteValues() {
        return this.values == null ? (this.values = new VCol(this.byteValueEntrySet())) : this.values;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (ByteValueMap.PrimitiveEntryV<K> e : this.byteValueEntrySet()) {
            s.writeObject(e.getKey());
            s.writeByte(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            this._putEntry(s.readObject(), s.readByte());
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$1(ByteValueHashMap byteValueHashMap) {
        return byteValueHashMap.ent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ESet
    extends AbstractSet<ByteValueMap.PrimitiveEntryV<K>> {
        private ESet() {
        }

        @Override
        public Iterator<ByteValueMap.PrimitiveEntryV<K>> iterator() {
            return new Iterator<ByteValueMap.PrimitiveEntryV<K>>(){
                private int ptr = 0;
                private Ent<?> e = this._next();
                private Ent<?> remove = null;
                private int exModCount;
                {
                    this.exModCount = ByteValueHashMap.this.modCount;
                }

                /*
                 * Unable to fully structure code
                 */
                private Ent<?> _next() {
                    if (Ent.access$0(this.e) == null) ** GOTO lbl5
                    return Ent.access$0(this.e);
lbl-1000:
                    // 1 sources

                    {
                        if (ByteValueHashMap.access$1(ESet.access$1(ESet.this))[this.ptr] == null) continue;
                        return ByteValueHashMap.access$1(ESet.access$1(ESet.this))[this.ptr];
lbl5:
                        // 2 sources

                        ** while (++this.ptr < ByteValueHashMap.access$1((ByteValueHashMap)ESet.access$1((ESet)ESet.this)).length)
                    }
lbl6:
                    // 1 sources

                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.e != null;
                }

                @Override
                public ByteValueMap.PrimitiveEntryV<K> next() {
                    this.remove = this.e;
                    if (this.e == null) {
                        throw new NoSuchElementException();
                    }
                    if (this.exModCount != ByteValueHashMap.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    this.e = this._next();
                    return this.remove;
                }

                @Override
                public void remove() {
                    if (this.remove == null) {
                        throw new IllegalStateException();
                    }
                    ByteValueHashMap.this.remove(((Ent)this.e).key);
                    this.exModCount = ByteValueHashMap.this.modCount;
                    this.remove = null;
                }
            };
        }

        @Override
        public int size() {
            return ByteValueHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Ent) {
                return ByteValueHashMap.this.containsKey(((Ent)o).key);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Ent) {
                return ByteValueHashMap.this._remove(((Ent)o).getKey()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            ByteValueHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ent<K>
    implements ByteValueMap.PrimitiveEntryV<K> {
        private K key;
        private byte value;
        private Ent<?> next;

        private Ent(K key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public byte getValue() {
            return this.value;
        }

        @Override
        public byte setValue(byte v) {
            byte r = this.value;
            this.value = v;
            return r;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == null && e.key == null || this.key != null && this.key.equals(e.key) && this.value == e.value;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private Ent<?> searchEntry(Object k) {
            Ent<?> f = this;
            while (f != null) {
                if (f.key == null && k == null || k != null && k.equals(f.key)) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent<?> removeEntry(Object k) {
            Ent<?> g = this;
            Ent<?> f = this.next;
            while (f != null) {
                if (f.key == null && k == null || k != null && k.equals(f.key)) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Byte putEntry(K k, byte v) {
            Ent<?> g = this;
            Ent<?> f = this.next;
            while (f != null) {
                if (f.key == null && k == null || k != null && k.equals(f.key)) {
                    Byte r = new Byte(f.value);
                    f.value = v;
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent<K>(k, v);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KSet
    extends AbstractSet<K> {
        private Set<ByteValueMap.PrimitiveEntryV<K>> eset;

        private KSet(Set<ByteValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public K next() {
                    return ((ByteValueMap.PrimitiveEntryV)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return ByteValueHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return ByteValueHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ByteValueHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            ByteValueHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCol
    extends AbstractByteCollection {
        private Set<ByteValueMap.PrimitiveEntryV<K>> eset;

        private VCol(Set<ByteValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator ei = this.eset.iterator();
            return new ByteIterator(){

                public boolean hasNext() {
                    return ei.hasNext();
                }

                public byte next() {
                    return ((ByteValueMap.PrimitiveEntryV)ei.next()).getValue();
                }

                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return ByteValueHashMap.this.size;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }
    }
}

