/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractLongCollection;
import net.morilib.util.primitive.AbstractLongVector;
import net.morilib.util.primitive.LongCollection;
import net.morilib.util.primitive.LongList;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.LongSortedSet;
import net.morilib.util.primitive.LongVector;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.iterator.LongIterators;
import net.morilib.util.primitive.iterator.LongVectorIterator;

public final class LongCollections {
    public static final LongSet EMPTY_SET = new _EmptyS();
    public static final LongSortedSet EMPTY_SORTED_SET = new _EmptyS();
    public static final LongVector EMPTY_VECTOR = new _EmptyV();

    private LongCollections() {
    }

    public static LongCollection unmodifiableCollection(LongCollection c) {
        return c instanceof UnmodifiableCol ? c : new UnmodifiableCol(c);
    }

    public static LongSet unmodifiableSet(LongSet set) {
        return set instanceof UnmodifiableSet ? set : new UnmodifiableSet(set);
    }

    public static LongSortedSet unmodifiableSortedSet(LongSortedSet set) {
        return set instanceof UnmodifiableSSet ? set : new UnmodifiableSSet(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableCol
    extends AbstractLongCollection {
        LongCollection wrapee;

        UnmodifiableCol(LongCollection s) {
            this.wrapee = s;
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllLong(LongCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllLong(LongCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllLong(Collection<? extends LongCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsLong(long v) {
            return this.wrapee.contains(v);
        }

        @Override
        public boolean containsAllLong(LongCollection a) {
            return this.wrapee.containsAllLong(a);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public LongIterator longIterator() {
            return new Itr(this.wrapee.longIterator());
        }

        @Override
        public boolean removeLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllLong(LongCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllLong(LongCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public long[] toLongArray() {
            return this.wrapee.toLongArray();
        }

        @Override
        public long[] toLongArray(long[] a) {
            return this.wrapee.toLongArray(a);
        }

        @Override
        public boolean isInfinite() {
            return this.wrapee.isInfinite();
        }

        @Override
        public LongSet toSet() {
            return this.wrapee.toSet();
        }

        private static class Itr
        implements LongIterator {
            private LongIterator itr;

            private Itr(LongIterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public long next() {
                return this.itr.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class UnmodifiableSSet
    extends UnmodifiableSet
    implements LongSortedSet {
        UnmodifiableSSet(LongCollection s) {
            super(s);
        }

        public LongSortedSet collect(LongSortedSet set) {
            return ((LongSortedSet)this.wrapee).collect(set);
        }

        public long first() {
            return ((LongSortedSet)this.wrapee).first();
        }

        public LongSortedSet headSet(long v) {
            return LongCollections.unmodifiableSortedSet(((LongSortedSet)this.wrapee).headSet(v));
        }

        public LongSortedSet subSet(long s, long e) {
            return LongCollections.unmodifiableSortedSet(((LongSortedSet)this.wrapee).subSet(s, e));
        }

        public LongSortedSet tailSet(long v) {
            return LongCollections.unmodifiableSortedSet(((LongSortedSet)this.wrapee).tailSet(v));
        }

        public long last() {
            return ((LongSortedSet)this.wrapee).last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCol
    implements LongSet {
        UnmodifiableSet(LongCollection s) {
            super(s);
        }

        public LongSet collect(LongSet set) {
            return ((LongSet)this.wrapee).collect(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _Empty
    extends AbstractLongCollection {
        private _Empty() {
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllLong(LongCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllLong(LongCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllLong(Collection<? extends LongCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsLong(long v) {
            return false;
        }

        @Override
        public boolean containsAllLong(LongCollection a) {
            return a.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean removeLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllLong(LongCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllLong(LongCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LongIterator longIterator() {
            return new LongIterator(){

                public boolean hasNext() {
                    return false;
                }

                public long next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isInfinite() {
            return true;
        }
    }

    private static class _EmptyS
    extends _Empty
    implements LongSortedSet {
        private _EmptyS() {
        }

        public LongSet collect(LongSet set) {
            return this;
        }

        public LongSortedSet collect(LongSortedSet set) {
            return this;
        }

        public long first() {
            throw new NoSuchElementException();
        }

        public LongSortedSet headSet(long v) {
            return this;
        }

        public LongSortedSet subSet(long s, long e) {
            return this;
        }

        public LongSortedSet tailSet(long v) {
            return this;
        }

        public long last() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _EmptyV
    extends AbstractLongVector
    implements Serializable {
        private static final long serialVersionUID = 1540238742681016912L;
        private static final _Itr ITR = new _Itr();

        private _EmptyV() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public long first() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Long set(int index, Long element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Long element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<Long> listIterator() {
            return ITR;
        }

        @Override
        public ListIterator<Long> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIterator();
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public void addLong(int index, long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllLong(int index, LongCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOfLong(long v) {
            return -1;
        }

        @Override
        public int indexOf(int v) {
            return -1;
        }

        @Override
        public long removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LongList rest() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public LongList rest(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public long setLong(int index, long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long set(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOfLong(long v) {
            return -1;
        }

        @Override
        public LongVectorIterator longVectorIterator() {
            return LongIterators.NULL_ITERATOR;
        }

        @Override
        public LongVectorIterator longVectorIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.longVectorIterator();
        }

        @Override
        public LongVector subVector(int start, int end) {
            if (start != 0 || end != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class _Itr
        implements ListIterator<Long> {
            private _Itr() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Long next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public Long previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Long e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Long e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

