/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractFloatCollection;
import net.morilib.util.primitive.AbstractFloatVector;
import net.morilib.util.primitive.FloatCollection;
import net.morilib.util.primitive.FloatList;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.FloatSortedSet;
import net.morilib.util.primitive.FloatVector;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.iterator.FloatIterators;
import net.morilib.util.primitive.iterator.FloatVectorIterator;

public final class FloatCollections {
    public static final FloatSet EMPTY_SET = new _EmptyS();
    public static final FloatSortedSet EMPTY_SORTED_SET = new _EmptyS();
    public static final FloatVector EMPTY_VECTOR = new _EmptyV();

    private FloatCollections() {
    }

    public static FloatCollection unmodifiableCollection(FloatCollection c) {
        return c instanceof UnmodifiableCol ? c : new UnmodifiableCol(c);
    }

    public static FloatSet unmodifiableSet(FloatSet set) {
        return set instanceof UnmodifiableSet ? set : new UnmodifiableSet(set);
    }

    public static FloatSortedSet unmodifiableSortedSet(FloatSortedSet set) {
        return set instanceof UnmodifiableSSet ? set : new UnmodifiableSSet(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableCol
    extends AbstractFloatCollection {
        FloatCollection wrapee;

        UnmodifiableCol(FloatCollection s) {
            this.wrapee = s;
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllFloat(FloatCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllFloat(FloatCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllFloat(Collection<? extends FloatCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsFloat(float v) {
            return this.wrapee.contains(Float.valueOf(v));
        }

        @Override
        public boolean containsAllFloat(FloatCollection a) {
            return this.wrapee.containsAllFloat(a);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public FloatIterator floatIterator() {
            return new Itr(this.wrapee.floatIterator());
        }

        @Override
        public boolean removeFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllFloat(FloatCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllFloat(FloatCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public float[] toFloatArray() {
            return this.wrapee.toFloatArray();
        }

        @Override
        public float[] toFloatArray(float[] a) {
            return this.wrapee.toFloatArray(a);
        }

        @Override
        public boolean isInfinite() {
            return this.wrapee.isInfinite();
        }

        @Override
        public FloatSet toSet() {
            return this.wrapee.toSet();
        }

        private static class Itr
        implements FloatIterator {
            private FloatIterator itr;

            private Itr(FloatIterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public float next() {
                return this.itr.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class UnmodifiableSSet
    extends UnmodifiableSet
    implements FloatSortedSet {
        UnmodifiableSSet(FloatCollection s) {
            super(s);
        }

        public FloatSortedSet collect(FloatSortedSet set) {
            return ((FloatSortedSet)this.wrapee).collect(set);
        }

        public float first() {
            return ((FloatSortedSet)this.wrapee).first();
        }

        public FloatSortedSet headSet(float v) {
            return FloatCollections.unmodifiableSortedSet(((FloatSortedSet)this.wrapee).headSet(v));
        }

        public FloatSortedSet subSet(float s, float e) {
            return FloatCollections.unmodifiableSortedSet(((FloatSortedSet)this.wrapee).subSet(s, e));
        }

        public FloatSortedSet tailSet(float v) {
            return FloatCollections.unmodifiableSortedSet(((FloatSortedSet)this.wrapee).tailSet(v));
        }

        public float last() {
            return ((FloatSortedSet)this.wrapee).last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCol
    implements FloatSet {
        UnmodifiableSet(FloatCollection s) {
            super(s);
        }

        public FloatSet collect(FloatSet set) {
            return ((FloatSet)this.wrapee).collect(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _Empty
    extends AbstractFloatCollection {
        private _Empty() {
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllFloat(FloatCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllFloat(FloatCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllFloat(Collection<? extends FloatCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsFloat(float v) {
            return false;
        }

        @Override
        public boolean containsAllFloat(FloatCollection a) {
            return a.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean removeFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllFloat(FloatCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllFloat(FloatCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FloatIterator floatIterator() {
            return new FloatIterator(){

                public boolean hasNext() {
                    return false;
                }

                public float next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isInfinite() {
            return true;
        }
    }

    private static class _EmptyS
    extends _Empty
    implements FloatSortedSet {
        private _EmptyS() {
        }

        public FloatSet collect(FloatSet set) {
            return this;
        }

        public FloatSortedSet collect(FloatSortedSet set) {
            return this;
        }

        public float first() {
            throw new NoSuchElementException();
        }

        public FloatSortedSet headSet(float v) {
            return this;
        }

        public FloatSortedSet subSet(float s, float e) {
            return this;
        }

        public FloatSortedSet tailSet(float v) {
            return this;
        }

        public float last() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _EmptyV
    extends AbstractFloatVector
    implements Serializable {
        private static final long serialVersionUID = 1540238742681016912L;
        private static final _Itr ITR = new _Itr();

        private _EmptyV() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public float first() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Float> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Float get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Float set(int index, Float element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Float element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Float remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<Float> listIterator() {
            return ITR;
        }

        @Override
        public ListIterator<Float> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIterator();
        }

        @Override
        public List<Float> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public void addFloat(int index, float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllFloat(int index, FloatCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getFloat(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOfFloat(float v) {
            return -1;
        }

        @Override
        public int indexOf(int v) {
            return -1;
        }

        @Override
        public float removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FloatList rest() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public FloatList rest(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public float setFloat(int index, float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float set(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOfFloat(float v) {
            return -1;
        }

        @Override
        public FloatVectorIterator floatVectorIterator() {
            return FloatIterators.NULL_ITERATOR;
        }

        @Override
        public FloatVectorIterator floatVectorIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.floatVectorIterator();
        }

        @Override
        public FloatVector subVector(int start, int end) {
            if (start != 0 || end != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class _Itr
        implements ListIterator<Float> {
            private _Itr() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Float next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public Float previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Float e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Float e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

