/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.map;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.morilib.util.Objects;
import net.morilib.util.SimpleMap;
import net.morilib.util.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleMap<K, V>
extends AbstractMap<K, V>
implements SimpleMap<K, V> {
    private Tuple2<K, V> value;

    public TupleMap(K var, V val) {
        this.value = new Tuple2<K, V>(var, val);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        TupleEntry<K, V> e = new TupleEntry<K, V>(this.value);
        return Collections.singleton(e);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        return Objects.equals(this.value.getB(), v);
    }

    @Override
    public boolean containsKey(Object key) {
        return Objects.equals(this.value.getA(), key);
    }

    @Override
    public V get(Object key) {
        return Objects.equals(this.value.getA(), key) ? (V)this.value.getB() : null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V map(K key) {
        return this.get(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TupleEntry<K, V>
    implements Map.Entry<K, V> {
        private Tuple2<K, V> value;

        public TupleEntry(Tuple2<K, V> value2) {
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.value.getA();
        }

        @Override
        public V getValue() {
            return this.value.getB();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TupleEntry) {
                return this.value.equals(((TupleEntry)obj).value);
            }
            return false;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

