/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.map;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lang.number.Numbers;
import net.morilib.util.Iterators;
import net.morilib.util.set.IntegerRangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMap<V>
extends AbstractMap<Integer, V>
implements Serializable {
    private static final long serialVersionUID = 163106680779272895L;
    private List<V> wrapee;

    public ListMap(List<V> lst) {
        this.wrapee = lst;
    }

    @Override
    public void clear() {
        this.wrapee.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Number) {
            return Numbers.between((Number)key, 0L, this.wrapee.size());
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapee.contains(value);
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return new _ESe();
    }

    @Override
    public V get(Object key) {
        if (key instanceof Number && Numbers.between((Number)key, 0L, this.wrapee.size())) {
            return this.wrapee.get(((Number)key).intValue());
        }
        return null;
    }

    @Override
    public Set<Integer> keySet() {
        return new IntegerRangeSet(0, this.wrapee.size() - 1);
    }

    @Override
    public V put(Integer key, V value) {
        int i = key;
        if (i >= 0 && i < this.wrapee.size()) {
            this.wrapee.set(i, value);
        }
        throw new IllegalArgumentException(key.toString());
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.wrapee.size();
    }

    @Override
    public Collection<V> values() {
        return new _VView();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _EEn
    implements Map.Entry<Integer, V> {
        private int now;

        private _EEn(int now) {
            this.now = now;
        }

        @Override
        public Integer getKey() {
            return this.now;
        }

        @Override
        public V getValue() {
            return ListMap.this.wrapee.get(this.now);
        }

        @Override
        public V setValue(V value) {
            return ListMap.this.wrapee.set(this.now, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _EIt
    implements Iterator<Map.Entry<Integer, V>> {
        private int now = 0;

        private _EIt() {
        }

        @Override
        public boolean hasNext() {
            return this.now < ListMap.this.wrapee.size();
        }

        @Override
        public Map.Entry<Integer, V> next() {
            return new _EEn(this.now++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ESe
    extends AbstractSet<Map.Entry<Integer, V>> {
        private _ESe() {
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Map.Entry<Integer, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Integer, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ListMap.this.wrapee.clear();
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new _EIt();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ListMap.this.wrapee.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _VView
    extends AbstractCollection<V> {
        private _VView() {
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ListMap.this.wrapee.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ListMap.this.wrapee.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ListMap.this.wrapee.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.wrapee.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return Iterators.unmodifiable(ListMap.this.wrapee.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ListMap.this.wrapee.size();
        }

        @Override
        public Object[] toArray() {
            return ListMap.this.wrapee.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ListMap.this.wrapee.toArray(a);
        }
    }
}

