/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.bit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.morilib.lang.algebra.BooleanAlgebra;
import net.morilib.util.bit.BitSet2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitSet2Class
implements BooleanAlgebra<BitSet2>,
Serializable {
    private static final long serialVersionUID = 6360034344318517359L;
    private int max;
    private int min;
    private transient BitSet2 zero;
    private transient BitSet2 one;

    public BitSet2Class(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        this.max = max;
        this.min = min;
        this.zero = new BitSet2(this);
        this.one = this.zero.complement();
    }

    public int getSize() {
        return this.max - this.min + 1;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public BitSet2 newInstance() {
        return new BitSet2(this);
    }

    @Override
    public BitSet2 get0() {
        return this.zero;
    }

    @Override
    public BitSet2 get1() {
        return this.one;
    }

    @Override
    public BitSet2 join(BitSet2 x, BitSet2 y) {
        return x.join(y);
    }

    public BitSet2 join(BitSet2 ... as) {
        BitSet2 r = new BitSet2(this.get0());
        BitSet2[] bitSet2Array = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet2 a = bitSet2Array[n2];
            r.addAll(a);
            ++n2;
        }
        return r;
    }

    @Override
    public BitSet2 meet(BitSet2 x, BitSet2 y) {
        return x.meet(y);
    }

    public BitSet2 meet(BitSet2 ... as) {
        BitSet2 r = new BitSet2(this.get1());
        BitSet2[] bitSet2Array = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet2 a = bitSet2Array[n2];
            r.retainAll(a);
            ++n2;
        }
        return r;
    }

    @Override
    public BitSet2 complement(BitSet2 x) {
        return x.complement();
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + this.max);
        r = 37 * (r + this.min);
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitSet2Class) {
            BitSet2Class c = (BitSet2Class)obj;
            return this.max == c.max && this.min == c.min;
        }
        return false;
    }

    public String toString() {
        return "BitSetClass:[" + this.min + ", " + this.max + "]";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.zero = new BitSet2(this);
        this.one = this.zero.complement();
    }
}

