/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.util.Set;
import java.util.SortedSet;
import net.morilib.range.Interval;
import net.morilib.range.Limit;
import net.morilib.range.MergedRange;
import net.morilib.range.RangeAdder;
import net.morilib.range.Ranges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Range {
    public static final Interval O = new Interval(Limit.MAXIMUM, true, Limit.MINIMUM, true);
    public static final Interval U = new Interval(Limit.MINIMUM, true, Limit.MAXIMUM, true);

    public static Range newPoints(Set<?> s) {
        if (s.isEmpty()) {
            return O;
        }
        RangeAdder a = new RangeAdder();
        for (Object t : s) {
            a.add(Interval.newPoint(t));
        }
        return a.toRange();
    }

    public static Range newPointPair(Object v1, Object v2) {
        return Ranges.sum(Interval.newPoint(v1), Interval.newPoint(v2));
    }

    public abstract Range bound();

    public abstract boolean isOpen();

    public abstract boolean isClosed();

    public abstract SortedSet<?> boundElements();

    abstract boolean isInfimumBoundAbove(Object var1);

    abstract boolean isInfimumBoundBelow(Object var1);

    abstract boolean isInfimumBoundEqualTo(Object var1);

    abstract boolean isSupremumBoundAbove(Object var1);

    abstract boolean isSupremumBoundBelow(Object var1);

    abstract boolean isSupremumBoundEqualTo(Object var1);

    abstract boolean isInfimumBoundAboveAnyClosureOf(Range var1);

    abstract boolean isInfimumBoundBelowAnyClosureOf(Range var1);

    abstract boolean isSupremumBoundAboveAnyClosureOf(Range var1);

    abstract boolean isSupremumBoundBelowAnyClosureOf(Range var1);

    abstract boolean isInfimumBoundAboveAllClosureOf(Range var1);

    abstract boolean isInfimumBoundBelowAllClosureOf(Range var1);

    abstract boolean isSupremumBoundAboveAllClosureOf(Range var1);

    abstract boolean isSupremumBoundBelowAllClosureOf(Range var1);

    abstract boolean contactInfimumBound(Range var1);

    abstract boolean contactSupremumBound(Range var1);

    abstract boolean commonInfimumBoundTo(Range var1);

    abstract boolean commonSupremumBoundTo(Range var1);

    abstract boolean isInfimumAbove(Object var1);

    abstract boolean isInfimumBelow(Object var1);

    abstract boolean isInfimumEqualTo(Object var1);

    abstract boolean isSupremumAbove(Object var1);

    abstract boolean isSupremumBelow(Object var1);

    abstract boolean isSupremumEqualTo(Object var1);

    public abstract boolean infimumBoundIn(Range var1);

    public abstract boolean supremumBoundIn(Range var1);

    public abstract SortedSet<Interval> intervals();

    public abstract Range closure();

    public abstract Range interior();

    public abstract boolean isInfimumOpen();

    public abstract boolean isInfimumClosed();

    public abstract boolean isInfimumFinite();

    public abstract boolean isSupremumOpen();

    public abstract boolean isSupremumClosed();

    public abstract boolean isSupremumFinite();

    public abstract int hashCode();

    boolean isInfimumAboveAllOf(Range r) {
        return this.isInfimumBoundAboveAllClosureOf(r) || this.contactInfimumBound(r) && (r.isSupremumOpen() || this.isInfimumOpen());
    }

    boolean isInfimumBelowAllOf(Range r) {
        return this.isInfimumBoundBelowAllClosureOf(r) || this.commonInfimumBoundTo(r) && r.isInfimumOpen();
    }

    boolean isInfimumAboveAnyOf(Range r) {
        return this.isInfimumFinite() && (this.isInfimumBoundAboveAnyClosureOf(r) || this.commonInfimumBoundTo(r) && r.isInfimumClosed() && this.isInfimumOpen());
    }

    boolean isInfimumBelowAnyOf(Range r) {
        return this.isInfimumBoundBelowAnyClosureOf(r);
    }

    boolean contactInfimum(Range r) {
        return this.contactInfimumBound(r) && r.isSupremumClosed() && this.isInfimumClosed();
    }

    boolean commonInfimumTo(Range r) {
        return this.commonInfimumBoundTo(r) && r.isInfimumClosed() && this.isInfimumClosed();
    }

    boolean isSupremumAboveAllOf(Range r) {
        return this.isSupremumBoundAboveAllClosureOf(r) || this.commonSupremumBoundTo(r) && r.isSupremumOpen();
    }

    boolean isSupremumBelowAllOf(Range r) {
        return this.isSupremumBoundBelowAllClosureOf(r) || this.contactSupremumBound(r) && (r.isInfimumOpen() || this.isSupremumOpen());
    }

    boolean isSupremumAboveAnyOf(Range r) {
        return this.isSupremumBoundAboveAnyClosureOf(r);
    }

    boolean isSupremumBelowAnyOf(Range r) {
        return this.isSupremumFinite() && (this.isSupremumBoundBelowAnyClosureOf(r) || this.commonSupremumBoundTo(r) && r.isSupremumClosed() && this.isSupremumOpen());
    }

    boolean contactSupremum(Range r) {
        return this.contactSupremumBound(r) && r.isSupremumClosed() && this.isInfimumClosed();
    }

    boolean commonSupremumTo(Range r) {
        return this.commonSupremumBoundTo(r) && r.isSupremumClosed() && this.isSupremumClosed();
    }

    public Range complement(Range r) {
        if (this.isEmpty() || r.isEmpty()) {
            return this;
        }
        RangeAdder bld = new RangeAdder();
        for (Interval o : r.intervals()) {
            Interval.limit(o, this, bld);
        }
        return bld.toRange();
    }

    public Range getInfimumRange() {
        Range res = null;
        for (Range range : this.intervals()) {
            if (res != null && !res.isInfimumBoundAboveAnyClosureOf(range)) continue;
            res = range;
        }
        return res;
    }

    public Range getSupremumRange() {
        Range res = null;
        for (Range range : this.intervals()) {
            if (res != null && !res.isSupremumBoundBelowAnyClosureOf(range)) continue;
            res = range;
        }
        return res;
    }

    public Range join(Range t) {
        Range r = t;
        if (r.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return r;
        }
        MergedRange u = new MergedRange(this);
        u.addAll(t.intervals());
        return u;
    }

    public Range meet(Range t) {
        Range r = t;
        if (this.isEmpty() || r.isEmpty()) {
            return O;
        }
        RangeAdder bld = new RangeAdder();
        for (Interval o : r.intervals()) {
            Interval.meet(o, this, bld);
        }
        return bld.toRange();
    }

    public boolean closureIndependentOf(Range t) {
        return this.independentOf(t) && this.boundsIndependentOf(t);
    }

    public boolean containsAny(Range t) {
        return !this.independentOf(t);
    }

    public abstract boolean contains(Object var1);

    public abstract boolean isNeighborhoodOf(Object var1);

    public abstract boolean containsClosure(Object var1);

    public abstract boolean containsBound(Object var1);

    public abstract boolean isEmpty();

    public abstract boolean in(Range var1);

    public abstract boolean independentOf(Range var1);

    public abstract boolean interiorIndependentOf(Range var1);

    public abstract boolean closureContains(Range var1);

    public abstract boolean interiorContains(Range var1);

    public abstract boolean containsAll(Range var1);

    public abstract boolean boundsIn(Range var1);

    public abstract boolean boundsIndependentOf(Range var1);

    public abstract boolean isFinite();

    public abstract SortedSet<?> getJavaSetIfFinite();

    public boolean isUniverse() {
        return !this.isSupremumFinite() && !this.isInfimumFinite();
    }

    public boolean equals(Object o) {
        if (o instanceof Range) {
            return this.in((Range)o) && ((Range)o).in(this);
        }
        return false;
    }
}

