/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math;

import java.math.BigInteger;

public final class Math2 {
    public static final double EULER_CONSTANT = 0.5772156649015329;
    public static final double GOLDEN_RATIO = 1.618033988749895;
    public static final int HARDY_RAMANUJAN_NUMBER = 1729;
    private static final BigInteger LIMIT_NRT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final int BASE = 16;
    private static final int LOG2BASE = 4;

    private Math2() {
    }

    public static final int minus1ToThe(int n) {
        return (n & 1) == 0 ? 1 : -1;
    }

    public static double decimalPart(double x) {
        double r = Math.IEEEremainder(x, 1.0);
        return r < 0.0 ? 1.0 + r : r;
    }

    public static boolean isInteger(double x) {
        return Math2.decimalPart(x) == 0.0;
    }

    private static int toInt(byte b) {
        return b < 0 ? (b & 0x7F) + 128 : b;
    }

    public static BigInteger sqrtExact(BigInteger q) {
        int i = 0;
        BigInteger s = BigInteger.ZERO;
        BigInteger t = BigInteger.ZERO;
        BigInteger r = BigInteger.ZERO;
        if (q.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (q.signum() < 0) {
            throw new IllegalArgumentException();
        }
        byte[] a = q.toByteArray();
        while (a[i] == 0) {
        }
        while (i < a.length) {
            int x = 0;
            if (s.signum() == 0) {
                t = BigInteger.valueOf(Math2.toInt(a[i]));
                while (x * x <= t.intValue()) {
                    ++x;
                }
                s = BigInteger.valueOf(--x);
            } else {
                BigInteger s0 = s;
                t = t.shiftLeft(8).add(BigInteger.valueOf(Math2.toInt(a[i])));
                while ((s = s0.shiftLeft(4).add(BigInteger.valueOf(x))).multiply(BigInteger.valueOf(x++)).compareTo(t) <= 0) {
                }
                s = s0.shiftLeft(4).add(BigInteger.valueOf(x -= 2));
            }
            t = t.subtract(s.multiply(BigInteger.valueOf(x)));
            s = s.add(BigInteger.valueOf(x));
            r = r.shiftLeft(4).add(BigInteger.valueOf(x));
            ++i;
        }
        return t.signum() == 0 ? r : r.negate();
    }

    private static BigInteger[] split(BigInteger b, int n) {
        BigInteger x;
        byte[] c = b.toByteArray();
        int l = 0;
        while (c[l] == 0) {
            ++l;
        }
        byte[] d = new byte[(c.length - l) * 2];
        int k = l;
        while (k < c.length) {
            d[(k - l) * 2] = (byte)(Math2.toInt(c[k]) >> 4);
            d[(k - l) * 2 + 1] = (byte)(Math2.toInt(c[k]) & 0xF);
            ++k;
        }
        BigInteger[] r = new BigInteger[(d.length + n - 1) / n];
        int i = d.length % n;
        if (i > 0) {
            x = BigInteger.ZERO;
            k = 0;
            while (k < i) {
                x = x.shiftLeft(4).add(BigInteger.valueOf(Math2.toInt(d[k])));
                ++k;
            }
            r[0] = x;
        }
        while (i < d.length) {
            x = BigInteger.ZERO;
            k = 0;
            while (k < n) {
                x = x.shiftLeft(4).add(BigInteger.valueOf(Math2.toInt(d[i + k])));
                ++k;
            }
            r[(i + n - 1) / n] = x;
            i += n;
        }
        return r;
    }

    public static BigInteger nrtExact(BigInteger q, int n) {
        BigInteger r = BigInteger.ZERO;
        BigInteger t = BigInteger.ZERO;
        int i = 0;
        if (q.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (q.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger[] a = Math2.split(q, n);
        while (i < a.length) {
            int b = 0;
            t = t.shiftLeft(4 * n).add(a[i]);
            r = r.shiftLeft(4);
            while (b < 16) {
                BigInteger x = r.add(BigInteger.valueOf(b)).pow(n);
                if (x.compareTo(t) > 0) break;
                ++b;
            }
            r = r.add(BigInteger.valueOf(b - 1));
            ++i;
        }
        return t.subtract(q).signum() == 0 ? r : r.negate();
    }

    public static BigInteger nrtExact(BigInteger q, BigInteger n) {
        if (n.signum() < 0 || n.compareTo(LIMIT_NRT) > 0) {
            throw new IllegalArgumentException();
        }
        return Math2.nrtExact(q, n.intValue());
    }

    public static BigInteger integerLog(BigInteger x, BigInteger b) {
        BigInteger s;
        BigInteger r = BigInteger.valueOf(-1L);
        BigInteger y = x;
        if (x.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        do {
            y = y.divide(b);
            s = y.remainder(b);
            r = r.add(BigInteger.ONE);
        } while (y.signum() > 0);
        return s.signum() == 0 ? r : r.negate();
    }

    /*
     * Unable to fully structure code
     */
    public static BigInteger pow(BigInteger b1, BigInteger b2) {
        a = b2.toByteArray();
        i = 0;
        r = BigInteger.ONE;
        if (b2.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (b2.signum() == 0) {
            return BigInteger.ONE;
        }
        if (b1.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (b1.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        if (!b1.equals(BigInteger.valueOf(-1L))) ** GOTO lbl16
        p = b2.remainder(BigInteger.valueOf(2L)).intValue();
        return BigInteger.valueOf(p == 0 ? 1 : -1);
lbl-1000:
        // 1 sources

        {
            ++i;
lbl16:
            // 2 sources

            ** while (a[i] == 0)
        }
lbl17:
        // 2 sources

        while (i < a.length) {
            r = r.pow(256);
            r = r.multiply(b1.pow(Math2.toInt(a[i])));
            ++i;
        }
        return r;
    }

    public static int gcd(int a, int b) {
        int r = Math.abs(a);
        int t = Math.abs(b);
        if (a == 0 && b == 0) {
            return 0;
        }
        int c = r;
        while (t > 0) {
            r = t;
            t = c % t;
        }
        return r;
    }

    public static long gcd(long a, long b) {
        long r = Math.abs(a);
        long t = Math.abs(b);
        if (a == 0L && b == 0L) {
            return 0L;
        }
        long c = r;
        while (t > 0L) {
            r = t;
            t = c % t;
        }
        return r;
    }

    public static int lcm(short a, short b) {
        return a == 0 || b == 0 ? 0 : a * b / Math2.gcd(a, b);
    }

    public static long lcm(int a, int b) {
        long r = a;
        long t = b;
        return r == 0L || t == 0L ? 0L : r * t / Math2.gcd(r, t);
    }
}

