/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.topology;

import java.math.BigInteger;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.math.algebra.ILispAddable;
import net.morilib.lisp.math.algebra.ILispMultipliable;
import net.morilib.util.IntMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispCardinality
extends Datum2
implements ILispAddable<LispCardinality>,
ILispMultipliable<LispCardinality>,
Comparable<LispCardinality> {
    static final int FINITE = 0;
    static final int INF_A = 1;
    static final int INF_C = 2;
    static final int INF_OVER_C = 3;
    public static final LispCardinality ZERO = new LispCardinality(0L, true);
    public static final LispCardinality A = new LispCardinality(1L, false);
    public static final LispCardinality C = new LispCardinality(2L, false);
    public static final LispCardinality OVER_C = new LispCardinality(3L, false);
    private BigInteger finite;
    private int infinite;

    private LispCardinality(long n, boolean isfinite) {
        if (isfinite) {
            this.finite = BigInteger.valueOf(n);
            this.infinite = 0;
        } else if (n > 0L) {
            this.finite = null;
            this.infinite = Math.min((int)n, 3);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private LispCardinality(BigInteger n) {
        this.finite = n;
        this.infinite = 0;
    }

    public static LispCardinality finiteValueOf(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new LispCardinality(n, true);
    }

    public static LispCardinality finiteValueOf(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        return new LispCardinality(n, true);
    }

    public static LispCardinality finiteValueOf(BigInteger n) {
        if (n.signum() < 0) {
            throw new IllegalArgumentException();
        }
        return new LispCardinality(n);
    }

    static LispCardinality infiniteValueOf(int n) {
        return new LispCardinality(n, false);
    }

    @Override
    public LispCardinality mul(LispCardinality y) {
        if (this.infinite == 0 && this.finite.signum() == 0) {
            return ZERO;
        }
        if (y.infinite == 0 && y.finite.signum() == 0) {
            return ZERO;
        }
        if (this.infinite == 0 && y.infinite == 0) {
            return LispCardinality.finiteValueOf(this.finite.multiply(y.finite));
        }
        return LispCardinality.infiniteValueOf(Math.max(this.infinite, y.infinite));
    }

    @Override
    public LispCardinality add(LispCardinality y) {
        if (this.infinite == 0 && y.infinite == 0) {
            return LispCardinality.finiteValueOf(this.finite.add(y.finite));
        }
        return LispCardinality.infiniteValueOf(Math.max(this.infinite, y.infinite));
    }

    public boolean isFinite() {
        return this.infinite == 0;
    }

    public boolean isCountable() {
        return this.infinite < 2;
    }

    public BigInteger toBigInteger() {
        return this.finite;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        switch (this.infinite) {
            case 0: {
                buf.append("#<cardinarity ");
                buf.append(this.finite.toString());
                break;
            }
            case 1: {
                buf.append("#<cardinarity ");
                buf.append("countable");
                break;
            }
            case 2: {
                buf.append("#<cardinarity ");
                buf.append("real set");
                break;
            }
            default: {
                buf.append("#<cardinarity ");
                buf.append("over power of real set");
            }
        }
        buf.append(">");
    }

    @Override
    public int compareTo(LispCardinality c) {
        if (this.infinite == 0 && c.infinite == 0) {
            return this.finite.compareTo(c.finite);
        }
        return IntMath.compareTo(this.infinite, c.infinite);
    }

    public int hashCode() {
        return this.infinite == 0 ? this.finite.hashCode() : -this.infinite;
    }

    public boolean equals(Object o) {
        if (o instanceof LispCardinality) {
            LispCardinality c = (LispCardinality)o;
            if (this.infinite == 0 && c.infinite == 0) {
                return this.finite.equals(c.finite);
            }
            return this.infinite == c.infinite;
        }
        return false;
    }
}

