/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.topology;

import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispString;
import net.morilib.lisp.topology.AbstractLispTopology;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispAllAtomsTopology
extends AbstractLispTopology {
    public static final LispAllAtomsTopology ALL_CHARS = new LispAllAtomsTopology(LispCharacter.class, "chars");
    public static final LispAllAtomsTopology ALL_STRINGS = new LispAllAtomsTopology(LispString.class, "strings");
    private Class<?> atomklass;
    private String name;

    public LispAllAtomsTopology(Class<?> atomklass, String name) {
        this.atomklass = atomklass;
        this.name = name;
    }

    @Override
    public boolean isNeighborhoodOf(Datum d) {
        return this.atomklass.isInstance(d);
    }

    @Override
    public boolean isContained(ILispTopology t) {
        if (t instanceof LispAllAtomsTopology) {
            return this.atomklass.isAssignableFrom(((LispAllAtomsTopology)t).atomklass);
        }
        return super.isContained(t);
    }

    @Override
    public boolean isIndependent(ILispTopology t) {
        if (t instanceof LispAllAtomsTopology) {
            return !this.atomklass.isAssignableFrom(((LispAllAtomsTopology)t).atomklass);
        }
        return super.isIndependent(t);
    }

    @Override
    public ILispTopology interior() {
        return this;
    }

    @Override
    public ILispTopology closure() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public LispCardinality cardinality() {
        return LispCardinality.A;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<all " + this.name + ">");
    }
}

