/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.swing.LispComponent;
import net.morilib.lisp.swing.LispComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutGridBag
extends BinaryArgs {
    private static final Map<Datum, Integer> _FILL = new HashMap<Datum, Integer>();

    static {
        _FILL.put(Symbol.getSymbol("none"), 0);
        _FILL.put(Symbol.getSymbol("horizontal"), 2);
        _FILL.put(Symbol.getSymbol("vertical"), 3);
        _FILL.put(Symbol.getSymbol("both"), 1);
    }

    private int getInt(Map<Symbol, Datum> m, String s, int def, LispMessage mesg) {
        Datum d = m.get(Symbol.getSymbol(s));
        if (d != null) {
            if (d instanceof LispSmallInt) {
                return d.getInt();
            }
            throw mesg.getError("err.require.smallint", d);
        }
        return def;
    }

    private double getDouble(Map<Symbol, Datum> m, String s, double def, LispMessage mesg) {
        Datum d = m.get(Symbol.getSymbol(s));
        if (d != null) {
            if (d instanceof LispReal) {
                return d.getRealDouble();
            }
            throw mesg.getError("err.require.smallint", d);
        }
        return def;
    }

    private void setConstraints(Datum cdr, GridBagConstraints g, LispMessage mesg) {
        Map<Symbol, Datum> m = LispUtils.assocToMapSymbol(cdr);
        g.gridx = this.getInt(m, "gridx", -1, mesg);
        g.gridwidth = this.getInt(m, "gridwidth", 1, mesg);
        g.gridheight = this.getInt(m, "gridheight", 1, mesg);
        g.weightx = this.getDouble(m, "weightx", 1.0, mesg);
        g.weighty = this.getDouble(m, "weighty", 1.0, mesg);
        g.ipadx = this.getInt(m, "ipadx", 0, mesg);
        g.ipady = this.getInt(m, "ipady", 0, mesg);
        Integer d = _FILL.get(m.get(Symbol.getSymbol("fill")));
        g.fill = d == null ? 0 : d;
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        GridBagConstraints g = new GridBagConstraints();
        ConsIterator itr = new ConsIterator(c2a);
        if (!(c1a instanceof LispComposite)) {
            throw mesg.getError("err.swing.require.composite", c1a);
        }
        Container c = ((LispComposite)((Object)c1a)).getPane();
        c.setLayout(new GridBagLayout());
        g.gridy = 0;
        while (itr.hasNext()) {
            List<Datum> l = LispUtils.consToList(itr.next(), mesg);
            int i = 0;
            while (i < l.size()) {
                Datum z = l.get(i);
                if (!(z instanceof Cons)) {
                    throw mesg.getError("err.swing.invalidlayout.gridbag", z);
                }
                Datum x = ((Cons)z).getCar();
                if (!(x instanceof LispComponent)) {
                    throw mesg.getError("err.swing.require.component", x);
                }
                this.setConstraints(((Cons)z).getCdr(), g, mesg);
                if (g.gridx == -1 && i + 1 == l.size()) {
                    g.gridwidth = 0;
                }
                c.add((Component)((LispComponent)((Object)x)).getComponent(), g);
                ++i;
            }
            ++g.gridy;
        }
        return Undef.UNDEF;
    }
}

