/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.painter.SchlushColor;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.LispSwing;

public abstract class GUIElement
extends Datum2
implements JavaObjective {
    public abstract Component getAWTComponent();

    public void addMouseListener(MouseListener l) {
        this.getAWTComponent().addMouseListener(l);
    }

    public void setBackground(Color c) {
        this.getAWTComponent().setBackground(c);
    }

    public void setPreferredWidth(int x) {
        Component c = this.getAWTComponent();
        c.setPreferredSize(new Dimension(x, c.getPreferredSize().height));
    }

    public void setPreferredHeight(int y) {
        Component c = this.getAWTComponent();
        c.setPreferredSize(new Dimension(c.getPreferredSize().width, y));
    }

    public int getBoundsX() {
        return this.getAWTComponent().getBounds().x;
    }

    public int getBoundsY() {
        return this.getAWTComponent().getBounds().y;
    }

    public void setBoundsX(int x) {
        Component c = this.getAWTComponent();
        c.setBounds(new Rectangle(x, c.getBounds().y));
    }

    public void setBoundsY(int y) {
        Component c = this.getAWTComponent();
        c.setBounds(new Rectangle(c.getBounds().x, y));
    }

    public Object toObject() {
        return this.getAWTComponent();
    }

    public static class AddMouseListenerS
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            if (body instanceof Cons) {
                Cons c = (Cons)body;
                if (c.getCar() instanceof GUIElement) {
                    MouseListener l = LispSwing.createMouseListener(c.getCdr(), body, env, mesg);
                    ((GUIElement)c.getCar()).addMouseListener(l);
                    return Undef.UNDEF;
                }
                throw mesg.getError("err.swing.require.guielement", c.getCar());
            }
            throw mesg.getError("err.argument", body);
        }
    }

    public static class GetBoundsX
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof GUIElement) {
                return LispInteger.valueOf(((GUIElement)c1a).getBoundsX());
            }
            throw mesg.getError("err.swing.require.guielement", c1a);
        }
    }

    public static class GetBoundsY
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof GUIElement) {
                return LispInteger.valueOf(((GUIElement)c1a).getBoundsY());
            }
            throw mesg.getError("err.swing.require.guielement", c1a);
        }
    }

    public static class GetGuiElementHeight
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof GUIElement) {
                return LispInteger.valueOf(((GUIElement)c1a).getAWTComponent().getHeight());
            }
            throw mesg.getError("err.swing.require.guielement", c1a);
        }
    }

    public static class GetGuiElementWidth
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof GUIElement) {
                return LispInteger.valueOf(((GUIElement)c1a).getAWTComponent().getWidth());
            }
            throw mesg.getError("err.swing.require.guielement", c1a);
        }
    }

    public static class SetBackgroundColorS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof GUIElement)) {
                throw mesg.getError("err.swing.require.guielement", c1a);
            }
            if (!(c2a instanceof SchlushColor)) {
                throw mesg.getError("err.require.color", c2a);
            }
            ((GUIElement)c1a).setBackground(((SchlushColor)c2a).getColor());
            return Undef.UNDEF;
        }
    }

    public static class SetBoundsXS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof GUIElement)) {
                throw mesg.getError("err.swing.require.guielement", c1a);
            }
            ((GUIElement)c1a).setBoundsX(SubrUtils.getSmallIntegerExact(c2a, mesg));
            return Undef.UNDEF;
        }
    }

    public static class SetBoundsYS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof GUIElement)) {
                throw mesg.getError("err.swing.require.guielement", c1a);
            }
            ((GUIElement)c1a).setBoundsY(SubrUtils.getSmallIntegerExact(c2a, mesg));
            return Undef.UNDEF;
        }
    }

    public static class SetPreferredHeightS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof GUIElement)) {
                throw mesg.getError("err.swing.require.guielement", c1a);
            }
            ((GUIElement)c1a).setPreferredHeight(SubrUtils.getSmallIntegerExact(c2a, mesg));
            return Undef.UNDEF;
        }
    }

    public static class SetPreferredWidthS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof GUIElement)) {
                throw mesg.getError("err.swing.require.guielement", c1a);
            }
            ((GUIElement)c1a).setPreferredWidth(SubrUtils.getSmallIntegerExact(c2a, mesg));
            return Undef.UNDEF;
        }
    }
}

