/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;

public class Lcm
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 1) {
            return LispInteger.ONE;
        }
        if (!(lst.get(0) instanceof LispReal)) {
            throw mesg.getError("err.require.int", lst.get(0));
        }
        LispReal res = (LispReal)lst.get(0);
        if (!res.isInteger()) {
            throw mesg.getError("err.require.int", res);
        }
        if (res.isEqualTo(LispInteger.ZERO)) {
            return res;
        }
        int i = 1;
        while (i < lst.size()) {
            Datum d = lst.get(i);
            if (d instanceof LispReal) {
                LispReal d2 = (LispReal)d;
                if (!d2.isInteger()) {
                    throw mesg.getError("err.require.int", d2);
                }
                BigInteger a = res.getBigInteger();
                BigInteger b = d2.getBigInteger();
                if (b.equals(BigInteger.ZERO)) {
                    if (res.isExact() && d2.isExact()) {
                        return LispInteger.ZERO;
                    }
                    return new LispDouble(0.0);
                }
                BigInteger r = a.abs().multiply(b.abs()).divide(a.gcd(b));
                res = res.isExact() && d2.isExact() ? LispInteger.valueOf(r) : new LispDouble(r.doubleValue());
            } else {
                throw mesg.getError("err.require.int", d);
            }
            ++i;
        }
        return res;
    }
}

