/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.algebra.ILispAddable;
import net.morilib.lisp.subr.MathOperator1;
import net.morilib.lisp.subr.SubrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Add
extends MathOperator1<ILispAddable<?>> {
    @Override
    protected ILispAddable calculate(ILispAddable o1, ILispAddable o2) {
        return o1.add(o2);
    }

    @Override
    protected LispNumber initValue() {
        return LispInteger.ZERO;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Datum s;
        ConsIterator itr = new ConsIterator(body);
        if (itr.hasNext() && (s = itr.next()) instanceof LispString) {
            StringBuilder b = new StringBuilder(s.getString());
            while (itr.hasNext()) {
                b.append(LispUtils.print(itr.next()));
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            return new LispString(b.toString());
        }
        return super.eval(body, env, mesg);
    }
}

