/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sound;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class Playable
extends Datum2 {
    private static final int WAIT_MILLISEC = 2000;
    private int repeat;
    private PlayThread thread = null;
    private SourceDataLine line;
    private int samplePerTime;
    private AudioFormat format;
    private File file;
    private AudioInputStream stream;

    private Playable() {
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<playable>");
    }

    /* synthetic */ Playable(Playable playable) {
        this();
    }

    public static class MakePlayable
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            Playable res = new Playable(null);
            String fln = SubrUtils.getString(c1a, mesg);
            if (!c2a.isTrue()) {
                res.repeat = -1;
            } else if (c2a instanceof LispSmallInt) {
                res.repeat = c2a.getInt();
            }
            try {
                File file = LispFiles.getFile(env, fln);
                res.file = file;
                File fl = file;
                AudioInputStream ais = AudioSystem.getAudioInputStream(fl);
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
                res.stream = audioInputStream;
                ais = audioInputStream;
                AudioFormat audioFormat = ais.getFormat();
                res.format = audioFormat;
                AudioFormat fmt = audioFormat;
                DataLine.Info dif = new DataLine.Info(SourceDataLine.class, fmt, -1);
                res.line = (SourceDataLine)AudioSystem.getLine(dif);
                res.samplePerTime = (int)((float)(2000 * fmt.getChannels()) * fmt.getSampleRate() * (float)fmt.getSampleSizeInBits() / 8.0f / 1000.0f);
                return res;
            }
            catch (IOException e) {
                throw mesg.getError("err.io");
            }
            catch (UnsupportedAudioFileException e) {
                throw mesg.getError("err.sound.file.invalid", c1a);
            }
            catch (LineUnavailableException e) {
                throw mesg.getError("err.sound.lineunavailable");
            }
        }
    }

    public static class PausePlaySound
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Playable) {
                Playable p = (Playable)c1a;
                if (p.thread == null || !p.thread.isAlive()) {
                    return LispBoolean.FALSE;
                }
                if (!p.thread.paused) {
                    p.thread.paused = true;
                    return LispBoolean.TRUE;
                }
                return LispBoolean.FALSE;
            }
            throw mesg.getError("err.sound.require.playable", c1a);
        }
    }

    public static class PlaySound
    extends UnaryArgs {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Playable) {
                Playable p = (Playable)c1a;
                if (p.thread == null) {
                    try {
                        Playable playable = p;
                        playable.getClass();
                        p.thread = playable.new PlayThread();
                        p.line.open();
                        p.line.flush();
                        p.line.start();
                        p.thread.start();
                    }
                    catch (LineUnavailableException e) {
                        throw mesg.getError("err.sound.lineunavailable");
                    }
                    return LispBoolean.TRUE;
                }
                if (!p.thread.isAlive()) {
                    return LispBoolean.FALSE;
                }
                if (p.thread.paused) {
                    PlayThread playThread = p.thread;
                    synchronized (playThread) {
                        p.thread.playing = true;
                        p.thread.paused = false;
                        p.thread.notifyAll();
                    }
                    return LispBoolean.TRUE;
                }
                if (!p.thread.playing) {
                    p.thread.playing = true;
                    return LispBoolean.TRUE;
                }
                return LispBoolean.FALSE;
            }
            throw mesg.getError("err.sound.require.playable", c1a);
        }
    }

    private class PlayThread
    extends Thread {
        private boolean playing = true;
        private boolean paused = false;
        private boolean first = true;

        private PlayThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (this.playing) {
                    byte[] wave = new byte[Playable.this.samplePerTime];
                    int l = Playable.this.stream.read(wave);
                    if (this.paused) {
                        PlayThread playThread = this;
                        synchronized (playThread) {
                            this.wait();
                            continue;
                        }
                    }
                    if (l > 0) {
                        Playable.this.line.write(wave, 0, l);
                        if (this.first) {
                            this.first = false;
                            continue;
                        }
                        int s = (int)((float)(l * 8 * 1000 / Playable.this.format.getChannels()) / Playable.this.format.getSampleRate() / (float)Playable.this.format.getSampleSizeInBits());
                        if (s <= 0) continue;
                        Thread.sleep(s);
                        continue;
                    }
                    Playable playable = Playable.this;
                    int n = playable.repeat - 1;
                    playable.repeat = n;
                    if (n == 0) break;
                    Playable.this.stream = AudioSystem.getAudioInputStream(Playable.this.file);
                    Playable.this.stream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, Playable.this.stream);
                }
                Playable.this.line.stop();
                Playable.this.line.close();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                // empty catch block
            }
        }
    }

    public static class StopPlaySound
    extends UnaryArgs {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Playable) {
                Playable p = (Playable)c1a;
                if (p.thread == null || !p.thread.isAlive()) {
                    return LispBoolean.FALSE;
                }
                if (p.thread.paused) {
                    PlayThread playThread = p.thread;
                    synchronized (playThread) {
                        p.thread.playing = false;
                        p.thread.paused = false;
                        p.thread.notifyAll();
                    }
                    return LispBoolean.TRUE;
                }
                if (p.thread.playing) {
                    p.thread.playing = false;
                    return LispBoolean.TRUE;
                }
                return LispBoolean.FALSE;
            }
            throw mesg.getError("err.sound.require.playable", c1a);
        }
    }
}

