/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.record;

import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.r6rs.record.R6RSRecord;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class RecordMutator
extends BinaryArgs {
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        int n = SubrUtils.getSmallIntegerExact(c2a, mesg);
        if (c1a instanceof RecordTypeDescriptor) {
            final RecordTypeDescriptor rtd = (RecordTypeDescriptor)((Object)c1a);
            Set<String> fld = rtd.getFieldNames();
            if (n < 0 || n >= fld.size()) {
                throw mesg.getError("err.r6rsrecord.field.outofrange", c2a);
            }
            final String rn = Iterators.get(fld, n);
            if (!rtd.isMutable(rn)) {
                throw mesg.getError("err.r6rsrecord.field.immutable", rn);
            }
            return new BinaryArgs("accessor " + rtd.getId()){

                protected Datum execute(Datum x, Datum s, Environment env, LispMessage mesg) {
                    if (!(x instanceof R6RSRecord)) {
                        throw mesg.getError("err.r6rsrecord.require.record", x);
                    }
                    if (!rtd.equals(((R6RSRecord)((Object)x)).getRtd())) {
                        throw mesg.getError("err.r6rsrecord.rtdmismatch");
                    }
                    ((R6RSRecord)((Object)x)).setField(rn, s);
                    return Undef.UNDEF;
                }
            };
        }
        throw mesg.getError("err.r6rsrecord.require.rtd", c1a);
    }
}

