/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.record;

import java.util.LinkedHashMap;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.r6rs.record.LispRecordTypeDescriptor;
import net.morilib.lisp.r6rs.record.RTDCreationException;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;
import net.morilib.lisp.subr.SenaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class MakeRecordTypeDescriptor
extends SenaryArgs {
    private static final Symbol MUTABLE = Symbol.getSymbol("mutable");
    private static final Symbol IMMUTABLE = Symbol.getSymbol("immutable");

    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Datum c5a, Datum c6a, Environment env, LispMessage mesg) {
        String nam = SubrUtils.getSymbolName(c1a, mesg);
        RecordTypeDescriptor rtd = null;
        String uid = c3a.isTrue() ? SubrUtils.getSymbolName(c3a, mesg) : null;
        boolean sld = c4a.isTrue();
        boolean opq = c5a.isTrue();
        LinkedHashMap<String, Boolean> fld = new LinkedHashMap<String, Boolean>();
        if (c2a.isTrue() && !(c2a instanceof RecordTypeDescriptor)) {
            throw mesg.getError("err.r6rsrecord.require.rtd", c2a);
        }
        if (!(c6a instanceof LispVector)) {
            throw mesg.getError("err.require.vector", c6a);
        }
        rtd = c2a.isTrue() ? (RecordTypeDescriptor)((Object)c2a) : null;
        LispVector vec = (LispVector)c6a;
        if (rtd != null && rtd.isSealed()) {
            throw mesg.getError("err.r6rsrecord.sealed", c2a);
        }
        if (rtd != null && rtd.isOpaque()) {
            opq = true;
        }
        int i = 0;
        while (i < vec.size()) {
            Datum x = SubrUtils.car(vec.get(i), mesg);
            String s = SubrUtils.getSymbolName(SubrUtils.cadr(vec.get(i), mesg), mesg);
            SubrUtils.cddrNull(vec.get(i), mesg);
            if (x.equals(MUTABLE)) {
                fld.put(s, Boolean.TRUE);
            } else if (x.equals(IMMUTABLE)) {
                fld.put(s, Boolean.FALSE);
            } else {
                throw mesg.getError("err.r6rsrecord.require.mutablity", vec.get(i));
            }
            ++i;
        }
        try {
            return LispRecordTypeDescriptor.newInstance(nam, rtd, uid, sld, opq, fld);
        }
        catch (RTDCreationException e) {
            throw mesg.getError("err.r6rsrecord.assert.rtd.cannotcreate");
        }
    }
}

