/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.record;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.r6rs.record.DefaultProtocol;
import net.morilib.lisp.r6rs.record.LispR6RSRecord;
import net.morilib.lisp.r6rs.record.R6RSRecord;
import net.morilib.lisp.r6rs.record.RCDCreationException;
import net.morilib.lisp.r6rs.record.RecordConstructorDescriptor;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;

public class LispRecordConstructorDescriptor
extends Datum2
implements RecordConstructorDescriptor {
    private RecordTypeDescriptor rtd;
    private RecordConstructorDescriptor parent;
    private Procedure protocol;

    public LispRecordConstructorDescriptor(RecordTypeDescriptor rtd, RecordConstructorDescriptor parent, Procedure protocol) throws RCDCreationException {
        if (rtd == null) {
            throw new NullPointerException();
        }
        if (rtd.getParent() == null && parent != null) {
            throw new RCDCreationException();
        }
        this.rtd = rtd;
        this.parent = parent;
        this.protocol = protocol == null ? new DefaultProtocol(rtd) : protocol;
    }

    public RecordTypeDescriptor getRtd() {
        return this.rtd;
    }

    public RecordConstructorDescriptor getParent() {
        return this.parent;
    }

    public Procedure getProtocol() {
        return this.protocol;
    }

    public R6RSRecord newInstance() {
        return new LispR6RSRecord(this.rtd);
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<record-constructor-descriptor ").append(this.rtd.getId()).append(">");
    }
}

