/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.record;

import java.util.LinkedHashMap;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.r6rs.record.R6RSRecord;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;

public class LispR6RSRecord
extends Datum2
implements R6RSRecord {
    private RecordTypeDescriptor rtd;
    Map<String, Datum> fields;

    public LispR6RSRecord(RecordTypeDescriptor rtd) {
        this.rtd = rtd;
        this.fields = new LinkedHashMap<String, Datum>();
        RecordTypeDescriptor r = rtd;
        while (r != null) {
            for (String s : r.getFieldNames()) {
                this.fields.put(s, Undef.UNDEF);
            }
            r = r.getParent();
        }
    }

    public Datum getSlot(Symbol sym) {
        return this.getField(sym.getName());
    }

    public boolean setSlot(Symbol sym, Datum val, LispMessage mesg) {
        return this.setField(sym.getName(), val);
    }

    public Datum getField(String v) {
        return this.fields.get(v);
    }

    public boolean setField(String v, Datum val) {
        if (!this.fields.containsKey(v)) {
            return false;
        }
        if (!this.rtd.isMutable(v)) {
            return false;
        }
        this.fields.put(v, val);
        return true;
    }

    public boolean isMutable(String v) {
        return this.rtd.isMutable(v);
    }

    public boolean isDefined(String v) {
        return this.fields.containsKey(v);
    }

    public RecordTypeDescriptor getRtd() {
        return this.rtd;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<r6rs-record ").append(this.rtd.getId()).append(">");
    }
}

