/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.morilib.lisp.painter.ILispImage;
import net.morilib.lisp.painter.ImageFactory;
import net.morilib.lisp.painter.ImagePainter;
import net.morilib.lisp.painter.SchlushFont;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.painter.geom.MutablePoint2D;

public class SchlushPainterFrame
extends ImagePainter
implements SchlushFrame,
ILispImage {
    BufferedImage image;
    private CoordinateMap coordinate;
    private final ImageFactory factory = new ImageFactory(){

        public Image getImage() {
            return SchlushPainterFrame.this.image;
        }
    };

    public SchlushPainterFrame(int x, int y, CoordinateMap coordinate) {
        this.image = new BufferedImage(x, y, 2);
        this.coordinate = coordinate;
    }

    public void addImage(SchlushFrame.ImageInfo img) throws InterruptedException {
        Graphics2D g = this.image.createGraphics();
        if (this.coordinate != null) {
            MutablePoint2D p0 = this.coordinate.transform(this.image.getWidth(), this.image.getHeight(), img.x, img.y);
            MutablePoint2D ps = this.coordinate.transformSize(this.image.getWidth(), this.image.getHeight(), img.sx, img.sy);
            g.drawImage(img.img, p0.getXInt(), p0.getYInt() - ps.getYInt(), ps.getXInt(), ps.getYInt(), null);
        } else {
            g.drawImage(img.img, (int)img.x, (int)img.y, (int)img.sx, (int)img.sy, null);
        }
        g.dispose();
    }

    public void addDrawer(Drawer drawer) {
        Graphics2D g = this.image.createGraphics();
        drawer.draw(g, this.image.getWidth(), this.image.getHeight(), this.coordinate);
        g.dispose();
    }

    public void addBackgroundDrawer(Drawer drawer) {
        this.addDrawer(drawer);
    }

    public int getImageWidth(Image img) {
        return img.getWidth(null);
    }

    public int getImageHeight(Image img) {
        return img.getHeight(null);
    }

    public ImageFactory getImageFactory() {
        return this.factory;
    }

    public void clearScreen() {
        Graphics2D g = this.image.createGraphics();
        g.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
        g.dispose();
    }

    public CoordinateMap getCoordinate() {
        return this.coordinate;
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public Rectangle2D calculateFontBounds(String str, SchlushFont font) {
        Graphics2D g2d = this.image.createGraphics();
        TextLayout tl = new TextLayout(str, font.font, g2d.getFontRenderContext());
        return tl.getBounds();
    }

    public void repaint() {
    }

    public Image getImage() {
        return this.image;
    }

    public double transformX(double x) {
        return this.coordinate.transform(this.getWidth(), this.getHeight(), x, 0.0).getX();
    }

    public double transformY(double y) {
        return this.coordinate.transform(this.getWidth(), this.getHeight(), 0.0, y).getY();
    }

    public double invertX(int x) {
        return this.coordinate.invert(this.getWidth(), this.getHeight(), x, 0.0).getX();
    }

    public double invertY(int y) {
        return this.coordinate.invert(this.getWidth(), this.getHeight(), 0.0, y).getY();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<painter-frame>");
    }
}

