/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.subr.SubrUtils;

public class SubrInetAddress
extends Subr {
    static InetAddress listToInetAddress(Datum body, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() != 4 && l.size() != 16) {
            throw mesg.getError("err.argument", body);
        }
        byte[] adr = new byte[l.size()];
        int i = 0;
        while (i < l.size()) {
            int x = SubrUtils.getSmallIntegerExact(l.get(i), mesg);
            if (x < 0 || x > 255) {
                throw mesg.getError("err.uvector.outofrange.u8", l.get(i));
            }
            adr[i] = (byte)x;
            ++i;
        }
        try {
            return InetAddress.getByAddress(adr);
        }
        catch (UnknownHostException e) {
            throw mesg.getError("err.net.host.unknown");
        }
    }

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        return new LispInetAddress(SubrInetAddress.listToInetAddress(body, mesg));
    }
}

