/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.matrix;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.matrix.ILispDatumMatrix;
import net.morilib.lisp.matrix.LispDatumMatrix;
import net.morilib.util.Strings;

public final class LispDatumMatrices {
    private LispDatumMatrices() {
    }

    public static void print(StringBuilder b, ILispDatumMatrix matrix) {
        String s;
        Datum d;
        int j;
        int l = -1;
        String dlm = "";
        int i = 0;
        while (i < matrix.rowSize()) {
            j = 0;
            while (j < matrix.columnSize()) {
                d = matrix.get(i, j);
                s = LispUtils.print(d);
                l = l < s.length() ? s.length() : l;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < matrix.rowSize()) {
            b.append("[");
            dlm = "";
            j = 0;
            while (j < matrix.columnSize()) {
                d = matrix.get(i, j);
                s = LispUtils.print(d);
                b.append(dlm).append(Strings.rpad(s, l));
                dlm = " ";
                ++j;
            }
            b.append("]\n");
            ++i;
        }
    }

    public static ILispDatumMatrix toDatumList(Datum x, LispMessage mesg) {
        ConsIterator i = new ConsIterator(x);
        int cls = -1;
        int cl0 = 0;
        int rws = 0;
        while (i.hasNext()) {
            ConsIterator j = new ConsIterator(i.next());
            while (j.hasNext()) {
                j.next();
                ++cl0;
            }
            if (cls < 0) {
                cls = cl0;
            } else if (cls != cl0) {
                throw mesg.getError("err.matrix.require.samecolumnsize");
            }
            cl0 = 0;
            ++rws;
        }
        if (cls <= 0 || rws <= 0) {
            throw mesg.getError("err.matrix.require.listoflist", x);
        }
        LispDatumMatrix m = new LispDatumMatrix(rws, cls);
        LispDatumMatrices.setMatrix(m, x);
        return m;
    }

    private static void setMatrix(LispDatumMatrix m, Datum x) {
        ConsIterator i = new ConsIterator(x);
        int cls = 0;
        int rws = 0;
        while (i.hasNext()) {
            ConsIterator j = new ConsIterator(i.next());
            while (j.hasNext()) {
                m.set(rws, cls, j.next());
                ++cls;
            }
            ++rws;
            cls = 0;
        }
    }

    public static LispDatumMatrix consTensorProduct(ILispVector r, ILispVector c) {
        LispDatumMatrix m = new LispDatumMatrix(r.size(), c.size());
        int i = 0;
        while (i < r.size()) {
            int j = 0;
            while (j < c.size()) {
                m.set(i, j, LispUtils.mul(r.get(i), c.get(j)));
                ++j;
            }
            ++i;
        }
        return m;
    }
}

