/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.matrix;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.math.LispPermutation;
import net.morilib.lisp.math.matrix.LispMatrices;
import net.morilib.lisp.math.matrix.LispMatrixException;
import net.morilib.lisp.matrix.ILispDatumMatrix;
import net.morilib.lisp.matrix.LispDatumMatrix;
import net.morilib.lisp.uvector.HomogeneousUnsignedArray;

public abstract class AbstractLispDatumMatrix
extends Datum2
implements ILispDatumMatrix,
ILispVector {
    public Datum get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(index / this.columnSize(), index % this.columnSize());
    }

    public int size() {
        return this.rowSize() * this.columnSize();
    }

    public ILispVector getRowVector(int row) {
        Datum[] r = new Datum[this.columnSize()];
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < this.columnSize()) {
            r[i] = this.get(row, i);
            ++i;
        }
        return new LispVector(r);
    }

    public ILispVector getColumnVector(int column) {
        Datum[] ra = new Datum[this.columnSize()];
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < this.rowSize()) {
            ra[i] = this.get(i, column);
            ++i;
        }
        return new LispVector(ra);
    }

    public ILispDatumMatrix transpose() {
        LispDatumMatrix r = new LispDatumMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(j, i, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public ILispDatumMatrix changeRow(final LispPermutation rowp) {
        if (rowp.size() != this.rowSize()) {
            throw new IllegalArgumentException();
        }
        return new AbstractLispDatumMatrix(){

            public Datum get(int row, int column) {
                return AbstractLispDatumMatrix.this.get(rowp.get(row), column);
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                AbstractLispDatumMatrix.this.set(rowp.get(row), column, x);
            }

            public int rowSize() {
                return AbstractLispDatumMatrix.this.rowSize();
            }

            public int columnSize() {
                return AbstractLispDatumMatrix.this.columnSize();
            }
        };
    }

    public ILispDatumMatrix changeColumn(final LispPermutation colp) {
        if (colp.size() != this.columnSize()) {
            throw new IllegalArgumentException();
        }
        return new AbstractLispDatumMatrix(){

            public Datum get(int row, int column) {
                return AbstractLispDatumMatrix.this.get(row, colp.get(column));
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                AbstractLispDatumMatrix.this.set(row, colp.get(column), x);
            }

            public int rowSize() {
                return AbstractLispDatumMatrix.this.rowSize();
            }

            public int columnSize() {
                return AbstractLispDatumMatrix.this.columnSize();
            }
        };
    }

    public ILispDatumMatrix submatrix(final int rowb, final int rowe, final int colb, final int cole) {
        if (rowb < 0 || rowb >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowe < 0 || rowe >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (colb < 0 || colb >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (cole < 0 || cole >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowe <= rowb) {
            throw new IllegalArgumentException();
        }
        if (cole <= colb) {
            throw new IllegalArgumentException();
        }
        return new AbstractLispDatumMatrix(){

            public Datum get(int row, int column) {
                if (row < 0 || row >= rowe - rowb) {
                    throw new IndexOutOfBoundsException();
                }
                if (column < 0 || column >= cole - colb) {
                    throw new IndexOutOfBoundsException();
                }
                return AbstractLispDatumMatrix.this.get(row + rowb, column + colb);
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                if (row < 0 || row >= rowe - rowb) {
                    throw new IndexOutOfBoundsException();
                }
                if (column < 0 || column >= cole - colb) {
                    throw new IndexOutOfBoundsException();
                }
                AbstractLispDatumMatrix.this.set(row + rowb, column + colb, x);
            }

            public int rowSize() {
                return rowe - rowb;
            }

            public int columnSize() {
                return cole - colb;
            }
        };
    }

    public ILispDatumMatrix submatrix(final HomogeneousUnsignedArray rowa, final HomogeneousUnsignedArray cola) throws LispMatrixException {
        int i = 0;
        while (i < rowa.size()) {
            if (!(rowa.get(i) instanceof LispSmallInt)) {
                throw new LispMatrixException("err.require.smallint");
            }
            if (rowa.get(i).getInt() >= this.rowSize()) {
                throw new LispMatrixException("err.range.invalid");
            }
            ++i;
        }
        i = 0;
        while (i < cola.size()) {
            if (!(cola.get(i) instanceof LispSmallInt)) {
                throw new LispMatrixException("err.require.smallint");
            }
            if (cola.get(i).getInt() >= this.columnSize()) {
                throw new LispMatrixException("err.range.invalid");
            }
            ++i;
        }
        return new AbstractLispDatumMatrix(){

            public Datum get(int row, int column) {
                return AbstractLispDatumMatrix.this.get(rowa.get(row).getInt(), cola.get(column).getInt());
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                AbstractLispDatumMatrix.this.set(rowa.get(row).getInt(), cola.get(column).getInt(), x);
            }

            public int rowSize() {
                return rowa.size();
            }

            public int columnSize() {
                return cola.size();
            }
        };
    }

    public void toDisplayString(StringBuilder buf) {
        LispMatrices.print(buf, this);
    }
}

