/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.special;

import net.morilib.lang.number.complex.ComplexDouble;
import net.morilib.lang.number.complex.RectanglarComplexDouble;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.math.special.CylinderFunctions;

public class BesselI
extends BinaryArgs {
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        LispComplex res;
        if (!(c1a instanceof LispComplex)) {
            throw mesg.getError("err.require.complex", c1a);
        }
        if (!(c2a instanceof LispComplex)) {
            throw mesg.getError("err.require.complex", c2a);
        }
        if (!((LispComplex)c2a).isReal()) {
            throw mesg.getError("err.require.real", c2a);
        }
        LispComplex z0 = (LispComplex)c1a;
        double nu = c2a.getRealDouble();
        if (z0.isReal()) {
            double r = CylinderFunctions.I(z0.getRealDouble(), nu);
            res = new LispDouble(r);
        } else {
            ComplexDouble z = RectanglarComplexDouble.valueOf(z0.getRealDouble(), z0.getImagDouble());
            ComplexDouble r = CylinderFunctions.I(z, nu);
            res = LispComplex.newComplex(r.realPart(), r.imagPart());
        }
        return res;
    }
}

