/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.LispMatrix;
import net.morilib.lisp.math.matrix.LispMatrixException;
import net.morilib.lisp.subr.SubrUtils;

public class MatrixMinus
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ILispMatrix r = null;
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (d instanceof ILispMatrix) {
                if (r == null) {
                    r = (LispMatrix)d;
                    continue;
                }
                try {
                    r = r.sub((ILispMatrix)((Object)d));
                    continue;
                }
                catch (LispMatrixException e) {
                    throw mesg.getError("err.matrix.require.samesize", d);
                }
            }
            throw mesg.getError("err.matrix.require.numbermatrix", d);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        if (r == null) {
            throw mesg.getError("err.argument", body);
        }
        return r;
    }
}

