/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;

public class LispPermutationMatrix
extends AbstractImmutableLispMatrix {
    private int[] order;
    private int parity;

    LispPermutationMatrix(int[] order, int parity) {
        this.order = order;
        this.parity = parity;
    }

    public LispNumber get(int row, int column) {
        return this.order[row] == column ? LispInteger.ONE : LispInteger.ZERO;
    }

    public int rowSize() {
        return this.order.length;
    }

    public int columnSize() {
        return this.order.length;
    }

    public LispNumber determinant() {
        return LispInteger.valueOf((this.parity & 1) == 0 ? 1 : -1);
    }

    public LispPermutationMatrix inv() {
        int[] no = new int[this.order.length];
        int i = 0;
        while (i < no.length) {
            no[this.order[i]] = i;
            ++i;
        }
        return new LispPermutationMatrix(no, this.parity);
    }
}

